/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class FrequencyDistributor
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private String mPointsValues;

    public FrequencyDistributor(ActivityOutput input, String pointsValues) {
        this.addInput("Sequence of values as input");
        this.addOutput("Frequency distribution as output");
        if (pointsValues == null) {
            throw new IllegalArgumentException("pointsValues must not be null");
        }
        this.mPointsValues = pointsValues;
        this.setInput(input);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("Input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    public int[] getDistribution() throws NoActivityOutputException, DataFormatException {
        ActivityOutput output = this.getOutput();
        String data = output.getData();
        String[] distrib = data.split(",");
        int numDistrib = distrib.length;
        int[] distribution = new int[numDistrib];
        for (int i = 0; i < numDistrib; ++i) {
            distribution[i] = new Integer(distrib[i]);
        }
        return distribution;
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<frequencyDistributor name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("<inputValues from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        xml.append("  <pointsValues>");
        xml.append(this.mPointsValues);
        xml.append("</pointsValues>\n");
        xml.append("  <distributionOutput name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</frequencyDistributor>");
        return xml.toString();
    }
}

