/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class CSVProjection
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private int mColumnNo;
    private String mDelimiter = ",";

    public CSVProjection(ActivityOutput input, int columnNo) {
        this.addInput("CSV input");
        this.addOutput("Column projection output");
        if (columnNo <= 0) {
            throw new IllegalArgumentException("columnNo must be > 0: " + columnNo);
        }
        this.mColumnNo = columnNo;
        this.setInput(input);
    }

    public CSVProjection(ActivityOutput input, int columnNo, String delimiter) {
        this(input, columnNo);
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter must not be null");
        }
        this.mDelimiter = delimiter;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<csvProjection name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("<csvInput from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        xml.append("  <columnNo>");
        xml.append(this.mColumnNo);
        xml.append("</columnNo>\n");
        xml.append("  <delimeter>");
        xml.append(this.mDelimiter);
        xml.append("</delimeter>\n");
        xml.append("  <columnOutput name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</csvProjection>");
        return xml.toString();
    }
}

