/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.transform;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class BlockAggregator
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private int mBlockSize;

    public BlockAggregator(ActivityOutput input) {
        this(input, 10);
    }

    public BlockAggregator(ActivityOutput input, int blockSize) {
        this.addInput("input");
        this.addOutput("output");
        this.setInput(input);
        this.setBlockSize(blockSize);
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public final void setBlockSize(int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("blockSize must be > 0 : " + blockSize);
        }
        this.mBlockSize = blockSize;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<blockAggregator name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("  <input from=\"");
        sb.append(this.getInputParameters()[0].getOutputName());
        sb.append("\"/>\n");
        sb.append("  <blocksize size=\"");
        sb.append(this.mBlockSize);
        sb.append("\"/>\n");
        sb.append("  <output name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>");
        sb.append("</blockAggregator>");
        return sb.toString();
    }
}

