/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.sql.ResultSetActivityOutputConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class WebRowSet
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private int mResultSetType;

    public WebRowSet(ActivityOutput input) {
        this.addInput("ResultSet");
        this.addOutput("WebRowSet");
        this.setInput(input);
        this.mResultSetType = 1003;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public int getResultSetType() {
        return this.mResultSetType;
    }

    public void setResultSetType(int resultSetType) {
        if (resultSetType != 1004 && resultSetType != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        this.mResultSetType = resultSetType;
    }

    public ResultSet getResultSet() throws NoActivityOutputException, DataFormatException {
        ActivityOutput resultSetOutput = this.getOutput();
        return ResultSetActivityOutputConverter.convert(resultSetOutput, this.mResultSetType);
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<sqlResultsToXML name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<resultSet from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("<webRowSet name=\"");
        sb.append(this.getOutput().getName());
        sb.append("\"/>\n");
        sb.append("</sqlResultsToXML>\n");
        return sb.toString();
    }
}

