/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.ParameterizedActivity;
import uk.org.ogsadai.client.toolkit.activity.sql.UpdateCountToIntOutputConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class SQLUpdate
extends ParameterizedActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mExpression;

    public SQLUpdate(String expression) {
        super("sqlParameter");
        if (expression == null) {
            throw new IllegalArgumentException("expression must not be null");
        }
        this.addOutput("ModifiedRowsCount");
        this.mExpression = expression;
    }

    public void setExpression(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression must not be null");
        }
        this.mExpression = expression;
    }

    public String getExpression() {
        return this.mExpression;
    }

    public int getModifiedRowsCount() throws NoActivityOutputException, DataFormatException {
        return UpdateCountToIntOutputConverter.convert(this.getOutput());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<sqlUpdateStatement name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append(this.generateParametersXML());
        sb.append("<expression>");
        sb.append(this.replaceSpecialCharacters(this.mExpression));
        sb.append("</expression>\n");
        sb.append("<resultStream name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</sqlUpdateStatement>\n");
        return sb.toString();
    }
}

