/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import java.util.HashMap;
import java.util.Map;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ParameterizedActivity;

public class SQLStoredProcedure
extends ParameterizedActivity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mProcedureName;
    private Map mOutParams = new HashMap();

    public SQLStoredProcedure(String procedureName) {
        super("sqlParameter");
        this.addOutput("ProcedureResultStream");
        this.setStoredProcedure(procedureName);
    }

    public void setStoredProcedure(String procedureName) {
        if (procedureName == null) {
            throw new IllegalArgumentException("procedureName must not be null");
        }
        this.mProcedureName = procedureName;
    }

    public String getProcedureName() {
        return this.mProcedureName;
    }

    public void registerOutParameter(int position, int type) {
        this.mOutParams.put(new Integer(position), new Integer(type));
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<sqlStoredProcedure name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append(this.generateParametersXML());
        if (this.mOutParams.size() > 0) {
            this.generateOutParametersXML(sb);
        }
        sb.append("<storedProcedureName>");
        sb.append(this.replaceSpecialCharacters(this.mProcedureName));
        sb.append("</storedProcedureName>\n");
        sb.append("<resultStream name=\"");
        sb.append(this.getOutput().getName());
        sb.append("\"/>\n");
        sb.append("</sqlStoredProcedure>\n");
        return sb.toString();
    }

    private void generateOutParametersXML(StringBuffer buf) {
        Object[] keys = this.mOutParams.keySet().toArray();
        int numKeys = keys.length;
        for (int i = 0; i < numKeys; ++i) {
            buf.append("<sqlOutParameter position=\"");
            buf.append(keys[i]);
            buf.append("\" type=\"");
            buf.append(this.mOutParams.get(keys[i]));
            buf.append("\"/>");
        }
    }
}

