/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class SQLResultToBytes
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2006";
    private int mColumnIndex;
    private int mBlockSize;

    public SQLResultToBytes(ActivityOutput input, int columnIndex) {
        this.mColumnIndex = columnIndex;
        this.mBlockSize = -1;
        this.addInput("ResultSet");
        this.addOutput("Value in a column of first row as stream of bytes");
        this.setInput(input);
    }

    public void setColumnIndex(int columnIndex) {
        this.mColumnIndex = columnIndex;
    }

    public void setBlockSize(int blockSize) {
        this.mBlockSize = blockSize;
    }

    public void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("Input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<sqlResultToBytes name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("  <resultSet from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        xml.append("  <columnIndex value=\"");
        xml.append(this.mColumnIndex);
        xml.append("\"/>\n");
        if (this.mBlockSize > 0) {
            xml.append("  <blockSize value=\"");
            xml.append(this.mBlockSize);
            xml.append("\"/>\n");
        }
        xml.append("<outputStream name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</sqlResultToBytes>");
        return xml.toString();
    }
}

