/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.sql.ResultSetActivityOutputConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class SQLResilientQuery
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mSqlStatement = null;
    private long mTimeout = -1L;
    private int mResultSetType;

    public SQLResilientQuery(String sql) {
        this.mSqlStatement = sql;
        this.addOutput("sqlResilientOutput");
        this.mResultSetType = 1003;
    }

    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    public void setResultSetType(int resultSetType) {
        if (resultSetType != 1004 && resultSetType != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        this.mResultSetType = resultSetType;
    }

    public ResultSet getResultSet() throws NoActivityOutputException, DataFormatException {
        ActivityOutput resultSetOutput = this.getOutput();
        return ResultSetActivityOutputConverter.convert(resultSetOutput, this.mResultSetType);
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<sqlResilient name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("<sqlStatement value=\"");
        xml.append(this.replaceSpecialCharacters(this.mSqlStatement));
        xml.append("\"/>\n");
        if (this.mTimeout >= 0L) {
            xml.append("<timeout>");
            xml.append(this.mTimeout);
            xml.append("</timeout>\n");
        }
        xml.append("<sqlResilientOutput name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</sqlResilient>\n");
        return xml.toString();
    }
}

