/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.sql.UpdateCountToIntOutputConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class SQLBulkLoad
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mTableName;
    private boolean mTransactionally = false;

    public SQLBulkLoad(ActivityOutput input, String tableName) {
        this.addInput("InputSource");
        this.addOutput("InsertedRowsCount");
        this.setInput(input);
        this.setTableName(tableName);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public final void setTableName(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("tableName must not be null");
        }
        this.mTableName = tableName;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public void setTransactionally(boolean transactionally) {
        this.mTransactionally = transactionally;
    }

    public boolean isTransactionally() {
        return this.mTransactionally;
    }

    public int getInsertedRowsCount() throws DataFormatException, NoActivityOutputException {
        ActivityOutput queryResultOutput = this.getOutputs()[0];
        int updateCount = UpdateCountToIntOutputConverter.convert(queryResultOutput);
        return updateCount;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<sqlBulkLoadRowSet name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<webRowSetStream from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("<loadIntoTable tableName=\"");
        sb.append(this.replaceSpecialCharacters(this.mTableName));
        sb.append("\" transactionally=\"");
        sb.append(Boolean.toString(this.mTransactionally));
        sb.append("\"/>\n");
        sb.append("<resultStream name=\"");
        sb.append(this.getOutput().getName());
        sb.append("\"/>\n");
        sb.append("</sqlBulkLoadRowSet>\n");
        return sb.toString();
    }
}

