/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import java.io.StringReader;
import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.csv.resultset.CSVToResultSet;
import uk.org.ogsadai.converters.webrowset.resultset.WebRowSetToResultSet;

public class ResultSetActivityOutputConverter {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";

    public static ResultSet convert(ActivityOutput output) throws NoActivityOutputException, DataFormatException {
        return ResultSetActivityOutputConverter.convert(output, 1003);
    }

    public static ResultSet convert(ActivityOutput output, int resultSetType) throws NoActivityOutputException, DataFormatException {
        if (resultSetType != 1004 && resultSetType != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        String data = output.getData();
        try {
            WebRowSetToResultSet converter = new WebRowSetToResultSet(new StringReader(data));
            converter.setResultSetType(resultSetType);
            return converter.getResultSet();
        }
        catch (Exception e) {
            throw new DataFormatException(data, e);
        }
    }

    public static ResultSet convertFromCSV(ActivityOutput output) throws NoActivityOutputException, DataFormatException {
        return ResultSetActivityOutputConverter.convertFromCSV(output, 1003, new CSVConfigurator());
    }

    public static ResultSet convertFromCSV(ActivityOutput output, int resultSetType) throws NoActivityOutputException, DataFormatException {
        return ResultSetActivityOutputConverter.convertFromCSV(output, resultSetType, new CSVConfigurator());
    }

    public static ResultSet convertFromCSV(ActivityOutput output, int resultSetType, CSVConfigurator configurator) throws NoActivityOutputException, DataFormatException {
        if (resultSetType != 1004 && resultSetType != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        String data = output.getData();
        try {
            CSVToResultSet converter = new CSVToResultSet(new StringReader(data));
            converter.setResultSetType(resultSetType);
            converter.setConfigurator(configurator);
            return converter.getResultSet();
        }
        catch (Exception e) {
            throw new DataFormatException(data, e);
        }
    }
}

