/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.sql;

import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.sql.ResultSetActivityOutputConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.converters.csv.CSVConfigurator;

public class CSV
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005";
    private int mResultSetType;
    private CSVConfigurator mConfigurator;

    public CSV(ActivityOutput input) {
        this.addInput("resultSet");
        this.addOutput("csvOutput");
        this.setInput(input);
        this.mResultSetType = 1003;
        this.mConfigurator = new CSVConfigurator();
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public int getResultSetType() {
        return this.mResultSetType;
    }

    public void setResultSetType(int resultSetType) {
        if (resultSetType != 1004 && resultSetType != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        this.mResultSetType = resultSetType;
    }

    public ResultSet getResultSet() throws NoActivityOutputException, DataFormatException {
        ActivityOutput resultSetOutput = this.getOutput();
        return ResultSetActivityOutputConverter.convertFromCSV(resultSetOutput, this.mResultSetType, this.mConfigurator);
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    public void setConfigurator(CSVConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("configurator must not be null");
        }
        this.mConfigurator = configurator;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<sqlResultsToCSV name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<resultSet from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("<delimiter value=\"");
        sb.append(this.mConfigurator.getMDelimiter());
        sb.append("\"/>\n");
        sb.append("<lineBreak value=\"");
        sb.append(this.mConfigurator.getMLineBreak());
        sb.append("\"/>\n");
        sb.append("<nullDataStr value=\"");
        sb.append(this.mConfigurator.getMNullDataStr());
        sb.append("\"/>\n");
        sb.append("<includeHeader value=\"");
        sb.append(this.mConfigurator.isMIncludeHeader());
        sb.append("\"/>\n");
        sb.append("<escapeFields value=\"");
        sb.append(this.mConfigurator.isMEscapeFields());
        sb.append("\"/>\n");
        sb.append("<csvOutput name=\"");
        sb.append(this.getOutput().getName());
        sb.append("\"/>\n");
        sb.append("</sqlResultsToCSV>\n");
        return sb.toString();
    }
}

