/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.relational;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.activity.relational.DatabaseSchemaActivityOutputConverter;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.converters.databaseschema.DatabaseSchemaMetaData;

public class DatabaseSchemaToXML
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";

    public DatabaseSchemaToXML(ActivityOutput input) {
        this.addInput("DatabaseSchema");
        this.addOutput("SchemaAsXML");
        this.setInput(input);
    }

    public DatabaseSchemaMetaData getAsDatabaseSchemaMetaData() throws NoActivityOutputException, DataFormatException {
        ActivityOutput output = this.getOutput();
        return DatabaseSchemaActivityOutputConverter.convert(output);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<databaseSchemaToXML name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("  <schema from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("  <output name=\"");
        sb.append(this.getOutput().getName());
        sb.append("\"/>\n");
        sb.append("</databaseSchemaToXML>\n");
        return sb.toString();
    }
}

