/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.misc;

public final class NotificationType {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final String NONE_STRING = "none";
    private static final String COMMENCED_STRING = "commenced";
    private static final String COMPLETE_STRING = "complete";
    public static final NotificationType NONE = new NotificationType("none");
    public static final NotificationType COMMENCED = new NotificationType("commenced");
    public static final NotificationType COMPLETE = new NotificationType("complete");
    private String mType = "none";

    private NotificationType(String type) {
        this.setType(type);
    }

    public void setType(String type) {
        if (type == null || !type.equals(NONE_STRING) && !type.equals(COMMENCED_STRING) && !type.equals(COMPLETE_STRING)) {
            throw new IllegalArgumentException("type must be one of NotificationType.NONE_STRING, NotificationType.COMMENCED_STRING or NotificationType.COMPLETE_STRING : " + type);
        }
        this.mType = type;
    }

    public void setNone() {
        this.setType(NONE_STRING);
    }

    public void setCommenced() {
        this.setType(COMMENCED_STRING);
    }

    public void setComplete() {
        this.setType(COMPLETE_STRING);
    }

    public boolean isNone() {
        return NONE_STRING.equals(this.mType);
    }

    public boolean isCommenced() {
        return COMMENCED_STRING.equals(this.mType);
    }

    public boolean isComplete() {
        return COMPLETE_STRING.equals(this.mType);
    }

    public String getAsString() {
        return this.mType;
    }
}

