/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.misc;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.misc.NotificationType;

public class Notification
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private NotificationType mNotificationType;
    private String mNotificationMessage;
    private static final int DATA_INPUT_INDEX = 0;
    private static final int DATA_OUTPUT_INDEX = 0;
    private static final int NOTIFICATION_OUTPUT_INDEX = 1;

    public Notification(ActivityOutput input) {
        this(input, NotificationType.NONE, NotificationType.NONE.getAsString());
    }

    public Notification(ActivityOutput input, NotificationType type, String message) {
        this.addInput("notificationDataInput");
        this.addOutput("notificationDataOutput");
        this.addOutput("notificationMessageOutput");
        this.setDataInput(input);
        this.setNotificationType(type);
        this.setNotificationMessage(message);
    }

    public void setNotificationMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        this.mNotificationMessage = message;
    }

    public void setNotificationType(NotificationType type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.mNotificationType = type;
    }

    public ActivityOutput getDataOutput() {
        return this.getOutputs()[0];
    }

    public ActivityOutput getNotificationOutput() {
        return this.getOutputs()[1];
    }

    public final void setDataInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<notification name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("  <notify type=\"");
        sb.append(this.mNotificationType.getAsString());
        sb.append("\"/>\n");
        sb.append("  <dataInput from=\"");
        sb.append(this.getInputParameters()[0].getOutputName());
        sb.append("\"/>\n");
        sb.append("  <dataOutput name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("  <notificationOutput name=\"");
        sb.append(this.getOutputs()[1].getName());
        sb.append("\"/>\n");
        sb.append("  <message>");
        sb.append(this.replaceSpecialCharacters(this.mNotificationMessage));
        sb.append("</message>\n");
        sb.append("</notification>");
        return sb.toString();
    }
}

