/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class DataStore
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private static final int NONE_SPECIFIED = 0;
    private static final int FROM_ACTIVITY = 1;
    private static final int HARD_CODED = 2;
    private int mType;
    private List mItems;

    public DataStore() {
        this.addInput("dataInput");
        this.addOutput("dataOutput");
        this.mItems = new ArrayList();
        this.mType = 0;
    }

    public DataStore(List items) {
        this();
        this.setItems(items);
    }

    public DataStore(ActivityOutput input) {
        this();
        this.setInput(input);
    }

    public void setInput(ActivityOutput input) {
        if (this.mType == 2) {
            throw new IllegalStateException("Type is HARD_CODED : " + this.mType);
        }
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
        this.mType = 1;
    }

    public void setItems(List items) {
        if (this.mType == 1) {
            throw new IllegalStateException("Type is FROM_ACTIVITY : " + this.mType);
        }
        if (items == null) {
            throw new IllegalArgumentException("items must not be null");
        }
        this.mItems = items;
        this.mType = 2;
    }

    public void addItem(Object item) {
        if (this.mType == 1) {
            throw new IllegalStateException("Type is FROM_ACTIVITY : " + this.mType);
        }
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        this.mItems.add(item);
        this.mType = 2;
    }

    public void addItems(List items) {
        if (this.mType == 1) {
            throw new IllegalStateException("Type is FROM_ACTIVITY : " + this.mType);
        }
        if (items == null) {
            throw new IllegalArgumentException("items must not be null");
        }
        this.mItems.addAll(items);
        this.mType = 2;
    }

    public ActivityOutput getOutput() {
        return super.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<dataStore name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        if (this.mType == 2) {
            Iterator iterator = this.mItems.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                sb.append("<item>" + super.replaceSpecialCharacters(item.toString()) + "</item>");
            }
            sb.append("\n");
        } else if (this.mType == 1) {
            sb.append("<input from=\"");
            sb.append(super.replaceSpecialCharacters(super.getInputParameters()[0].getOutputName()));
            sb.append("\"/>\n");
        } else {
            throw new IllegalStateException("Type is NONE_SPECIFIED. Either items must be directly provided, or an output from another activity must be specified.");
        }
        sb.append("<itemCursor name=\"");
        sb.append(super.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</dataStore>");
        return sb.toString();
    }
}

