/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.indexedfiles;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class ReadFile
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private String mFilename = null;
    private long mOffset = 0L;
    private boolean mIsBinary = true;
    private long mLength = -1L;
    private boolean mBase64encode = false;

    public ReadFile() {
        this.addInput("readFileInput");
        this.addOutput("readFileOutput");
    }

    public ReadFile(String filename) {
        this();
        this.setFilename(filename);
    }

    public ReadFile(ActivityOutput input) {
        this();
        this.setInput(input);
    }

    public void setFilename(String filename) {
        this.mFilename = filename;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public void setBinary(boolean isBinary) {
        this.mIsBinary = isBinary;
    }

    public boolean isBinary() {
        return this.mIsBinary;
    }

    public void setLength(long length) {
        if (length < -1L) {
            throw new IllegalArgumentException("length must be >= -1 : " + length);
        }
        this.mLength = length;
    }

    public long getLength() {
        return this.mLength;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must be >= 0 : " + offset);
        }
        this.mOffset = offset;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public boolean isBase64encoded() {
        return this.mBase64encode;
    }

    public void setBase64encode(boolean base64encode) {
        this.mBase64encode = base64encode;
    }

    public void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<readFile name=\"" + this.getName() + "\">\n");
        if (this.mFilename == null) {
            buf.append("<fromLocal from=\"");
            buf.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
            buf.append("\" />");
        } else {
            buf.append("<file>");
            buf.append(this.replaceSpecialCharacters(this.mFilename));
            buf.append("</file>");
            if (this.mIsBinary) {
                buf.append("<bytes offset=\"");
                buf.append(this.mOffset);
                buf.append("\" length=\"");
                buf.append(this.mLength);
                buf.append("\"/>");
            } else {
                buf.append("<lines offset=\"");
                buf.append(this.mOffset);
                buf.append("\" length=\"");
                buf.append(this.mLength);
                buf.append("\"/>");
            }
        }
        buf.append("<output name=\"");
        buf.append(this.getOutputs()[0].getName());
        buf.append("\" base64encode=\"");
        buf.append(this.mBase64encode);
        buf.append("\"/>\n");
        buf.append("</readFile>\n");
        return buf.toString();
    }
}

