/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.indexedfiles;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class IndexedFileSearch
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final int DATA_OUTPUT_INDEX = 0;
    private static final int STATUS_OUTPUT_INDEX = 1;
    private String mQuery = null;
    private String mIndexDirectory = null;

    public IndexedFileSearch() {
        this.addOutput("indexedFileSearchOutput");
        this.addOutput("indexedFileSearchStatus");
    }

    public IndexedFileSearch(String query) {
        this();
        this.setQuery(query);
        this.setIndex(null);
    }

    public IndexedFileSearch(String query, String index) {
        this();
        this.setQuery(query);
        this.setIndex(index);
    }

    public String getQuery() {
        return this.mQuery;
    }

    public void setQuery(String query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        this.mQuery = query;
    }

    public String getIndex() {
        return this.mIndexDirectory;
    }

    public void setIndex(String index) {
        this.mIndexDirectory = index;
    }

    public ActivityOutput getDataOutput() {
        ActivityOutput queryResultOutput = this.getOutputs()[0];
        return queryResultOutput;
    }

    public ActivityOutput getSearchStatus() {
        ActivityOutput queryResultOutput = this.getOutputs()[1];
        return queryResultOutput;
    }

    public long getResultCount() throws NoActivityOutputException, DataFormatException {
        String startTag;
        long count = 0L;
        ActivityOutput output = this.getOutputs()[1];
        String status = output.getData();
        if (!status.startsWith(startTag = "<searchResult resultCount=\"")) {
            throw new DataFormatException(startTag, status);
        }
        String endTag = "\">";
        int index = status.indexOf(endTag, startTag.length());
        String countStr = status.substring(startTag.length(), index);
        try {
            count = Long.parseLong(countStr);
        }
        catch (NumberFormatException e) {
            throw new DataFormatException("java.lang.Integer", status, e);
        }
        return count;
    }

    protected String generateXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<searchIndexedFile name=\"");
        buf.append(this.getName());
        buf.append("\">\n");
        buf.append("<query>");
        buf.append(this.replaceSpecialCharacters(this.mQuery));
        buf.append("</query>\n");
        if (this.mIndexDirectory != null) {
            buf.append("<index>");
            buf.append(this.replaceSpecialCharacters(this.mIndexDirectory));
            buf.append("</index>\n");
        }
        buf.append("<output name=\"");
        buf.append(this.getOutputs()[0].getName());
        buf.append("\"/>\n");
        buf.append("<status name=\"");
        buf.append(this.getOutputs()[1].getName());
        buf.append("\"/>\n");
        buf.append("</searchIndexedFile>");
        return buf.toString();
    }
}

