/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.indexedfiles;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class AddAndIndexFile
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private String mFilename = null;
    private String mDirectory = null;
    private String mFiletype = null;
    private String mIndex = null;
    private String[] mFields = null;

    public AddAndIndexFile() {
        this.addInput("addFileInput");
    }

    public AddAndIndexFile(String filename, String dirname) {
        this();
        this.setFile(filename, dirname);
    }

    public void setFile(String filename, String directory) {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.mFilename = filename;
        this.mDirectory = directory != null ? directory : "";
    }

    public String getFilename() {
        return this.mFilename;
    }

    public String getDirectory() {
        return this.mDirectory;
    }

    public void setFiletype(String filetype) {
        if (filetype == null) {
            throw new IllegalArgumentException("filetype must not be null");
        }
        this.mFiletype = filetype;
    }

    public String getFiletype() {
        return this.mFiletype;
    }

    public void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public String getIndex() {
        return this.mIndex;
    }

    public void setIndex(String index) {
        if (index == null) {
            index = "";
        }
        this.mIndex = index;
    }

    public void setFields(String[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields must not be null");
        }
        this.mFields = fields;
    }

    public String[] getFields() {
        return this.mFields;
    }

    protected String generateXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<addIndexFile name=\"");
        buf.append(this.getName());
        buf.append("\">\n");
        buf.append("<fromLocal from=\"");
        buf.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        buf.append("\" />");
        buf.append("<filename>");
        buf.append(this.replaceSpecialCharacters(this.mFilename));
        buf.append("</filename>\n");
        buf.append("<directory>");
        buf.append(this.replaceSpecialCharacters(this.mDirectory));
        buf.append("</directory>\n");
        buf.append("<filetype>");
        buf.append(this.replaceSpecialCharacters(this.mFiletype));
        buf.append("</filetype>\n");
        int numFields = this.mFields.length;
        for (int i = 0; i < numFields; ++i) {
            buf.append("<field>");
            buf.append(this.mFields[i]);
            buf.append("</field>");
        }
        buf.append("<index>");
        buf.append(this.replaceSpecialCharacters(this.mIndex));
        buf.append("</index>\n");
        buf.append("</addIndexFile>\n");
        return buf.toString();
    }
}

