/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.files;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public abstract class FileWriting
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    public static final int REPLACE = 1;
    public static final int DELETE = 2;
    public static final int APPEND = 3;
    public static final int INSERT = 4;
    public static final int NONE_SPECIFIED = Integer.MIN_VALUE;
    public static final int START = -1;
    public static final int END = -2;
    public static final int TO_END = -1;
    public static final boolean PER_LINE = true;
    public static final boolean PER_FILE = false;
    protected int mAction;
    protected String mFilename;
    protected String mRegexp;
    protected String mMatch;
    protected int mOffset = Integer.MIN_VALUE;
    protected int mLength = Integer.MIN_VALUE;
    protected String mText;
    protected boolean mPerLine;

    public FileWriting() {
        this.addOutput("actionResult");
    }

    protected void validateParams() {
        if (this.mFilename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        if (this.mOffset < 0 && this.mOffset != -1 && this.mOffset != -2 && this.mOffset != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("offset must be > 0 or equal to START or END or NONE_SPECIFIED : " + this.mOffset);
        }
        if (this.mLength < 0 && this.mLength != -1 && this.mLength != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("length must be > 0 or equal to TO_END or NONE_SPECIFIED : " + this.mLength);
        }
    }

    public void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        this.addInput("from");
        super.setInput(0, input.getName());
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<fileWritingActivity name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<file>");
        sb.append(this.replaceSpecialCharacters(this.getFilename()));
        sb.append("</file>");
        sb.append("<locate>");
        if (this.getRegexp() != null) {
            sb.append("<regexp>" + this.replaceSpecialCharacters(this.getRegexp()) + "</regexp>");
            if (this.getMatch() != null) {
                sb.append("<match>" + this.replaceSpecialCharacters(this.getMatch()) + "</match>");
            }
        } else {
            if (this.getOffset() != Integer.MIN_VALUE) {
                sb.append("<offset>" + FileWriting.offsetToString(this.getOffset()) + "</offset>");
            }
            if (this.getLength() != Integer.MIN_VALUE) {
                sb.append("<length>" + FileWriting.lengthToString(this.getLength()) + "</length>");
            }
        }
        sb.append("<perLine>" + this.isPerLine() + "</perLine>");
        sb.append("</locate>");
        sb.append("<" + FileWriting.actionToString(this.mAction) + " ");
        if (this.getText() != null) {
            sb.append("text=\"" + this.replaceSpecialCharacters(this.getText()) + "\"");
        } else if (this.getInputParameters().length > 0 && this.getInputParameters()[0] != null) {
            sb.append("from=\"");
            sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
            sb.append("\"");
        }
        sb.append("/>");
        sb.append("<output name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</fileWritingActivity>");
        return sb.toString();
    }

    public static String offsetToString(int offset) {
        switch (offset) {
            case -1: {
                return "start";
            }
            case -2: {
                return "end";
            }
        }
        return Integer.toString(offset);
    }

    public static String lengthToString(int length) {
        switch (length) {
            case -1: {
                return "toEnd";
            }
        }
        return Integer.toString(length);
    }

    public static String actionToString(int action) {
        switch (action) {
            case 1: {
                return "replace";
            }
            case 3: {
                return "append";
            }
            case 2: {
                return "delete";
            }
            case 4: {
                return "insert";
            }
        }
        return "unknownAction";
    }

    public String getFilename() {
        return this.mFilename;
    }

    public void setFilename(String filename) {
        this.mFilename = filename;
    }

    public String getMatch() {
        return this.mMatch;
    }

    public void setMatch(String match) {
        this.mMatch = match;
    }

    public boolean isPerLine() {
        return this.mPerLine;
    }

    public void setPerLine(boolean perLine) {
        this.mPerLine = perLine;
    }

    public String getRegexp() {
        return this.mRegexp;
    }

    public void setRegexp(String regexp) {
        this.mRegexp = regexp;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
    }

    public int getLength() {
        return this.mLength;
    }

    public void setLength(int length) {
        if (length < 0 && length != -1 && length != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("length must be > 0 or equal to TO_END or NONE_SPECIFIED : " + length);
        }
        this.mLength = length;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int offset) {
        if (offset < 0 && offset != -1 && offset != -2 && offset != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("offset must be > 0 or equal to START or END or NONE_SPECIFIED : " + offset);
        }
        this.mOffset = offset;
    }
}

