/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.files;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class DirectoryAccess
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private String mPath;
    private String[] mDirectories;
    private String[] mFiles;

    public DirectoryAccess() {
        this.addOutput("DirectoryContents");
    }

    public DirectoryAccess(String path) {
        this.addOutput("DirectoryContents");
        this.setPath(path);
    }

    public void setPath(String path) {
        this.mPath = path;
    }

    public String getPath() {
        return this.mPath;
    }

    public String[] getSubDirectories() throws NoActivityOutputException, DataFormatException {
        if (this.mDirectories == null) {
            this.parseData();
        }
        return this.mDirectories;
    }

    public String[] getFileNames() throws NoActivityOutputException, DataFormatException {
        if (this.mFiles == null) {
            this.parseData();
        }
        return this.mFiles;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<directoryAccessActivity name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        if (this.mPath != null) {
            xml.append("<path>");
            xml.append(this.mPath);
            xml.append("</path>");
        }
        xml.append("<output name=\"");
        xml.append(this.getOutput().getName());
        xml.append("\" />");
        xml.append("</directoryAccessActivity>");
        return xml.toString();
    }

    private void parseData() throws NoActivityOutputException, DataFormatException {
        Document document;
        String data = this.getOutput().getData();
        try {
            document = XMLUtilities.xmlStringToDOM(data, false);
        }
        catch (XMLDocumentException e) {
            throw new DataFormatException(e);
        }
        catch (XMLParseException e) {
            throw new DataFormatException(e);
        }
        NodeList dirNodes = document.getElementsByTagName("dir");
        this.mDirectories = new String[dirNodes.getLength()];
        for (int i = 0; i < dirNodes.getLength(); ++i) {
            Element element = (Element)dirNodes.item(i);
            this.mDirectories[i] = element.getFirstChild().getNodeValue();
        }
        NodeList fileNodes = document.getElementsByTagName("file");
        this.mFiles = new String[fileNodes.getLength()];
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            Element element = (Element)fileNodes.item(i);
            this.mFiles[i] = element.getFirstChild().getNodeValue();
        }
    }
}

