/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.examples;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;

public class DemoExternalInput
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private int mNumInputBlocks;
    private String mStreamName;

    public DemoExternalInput(int nInputBlocks, String streamName) {
        this.addOutput("SummedInputValues");
        this.mNumInputBlocks = nInputBlocks;
        if (streamName == null) {
            throw new IllegalArgumentException("streamName must not be null");
        }
        this.mStreamName = streamName;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    public int getSum() throws DataFormatException, NoActivityOutputException {
        ActivityOutput output = this.getOutputs()[0];
        String outputData = output.getData();
        try {
            return Integer.parseInt(outputData);
        }
        catch (NumberFormatException e) {
            throw new DataFormatException("java.lang.Integer", outputData, e);
        }
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<demoExternalInput name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("  <nInputBlocks value=\"");
        xml.append(this.mNumInputBlocks);
        xml.append("\"/>\n");
        xml.append("  <streamName value=\"");
        xml.append(this.mStreamName);
        xml.append("\"/>\n");
        xml.append("  <myOutput name=\"");
        xml.append(this.getOutputs()[0].getName());
        xml.append("\"/>\n");
        xml.append("</demoExternalInput>");
        return xml.toString();
    }
}

