/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import java.net.URI;
import java.net.URISyntaxException;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class DeliverToURL
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private String mURL = "";

    public DeliverToURL() {
        this.addInput("DeliverToURLInput");
    }

    public DeliverToURL(String url) {
        this();
        this.setURL(url);
    }

    public DeliverToURL(String url, ActivityOutput input) {
        this();
        this.setInput(input);
        this.setURL(url);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public void setURL(String url) {
        if (url == null || url.trim().equals("")) {
            throw new IllegalArgumentException("url must not be null or ''");
        }
        try {
            URI urlTest = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("url must be a legal URI : " + url);
        }
        this.mURL = url;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<deliverToURL name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<fromLocal from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("<toURL>");
        sb.append(this.replaceSpecialCharacters(this.mURL));
        sb.append("</toURL>");
        sb.append("</deliverToURL>");
        return sb.toString();
    }
}

