/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class DeliverToSMTP
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private List mRecipients;
    private String mSender;
    private String mSubject;
    private String mServer;

    public DeliverToSMTP() {
        this.addInput("DeliverToSMTPInput");
        this.mRecipients = new ArrayList();
        this.mSender = null;
        this.mSubject = null;
        this.mServer = null;
    }

    public DeliverToSMTP(List recipients, String sender, String subject, String server) {
        this();
        this.setRecipients(recipients);
        this.setSender(sender);
        this.setSubject(subject);
        this.setServer(server);
    }

    public void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public void setRecipients(List recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("recipients must not be null");
        }
        this.mRecipients = recipients;
    }

    public void addRecipient(String recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient must not be null");
        }
        this.mRecipients.add(recipient);
    }

    public void addRecipients(List recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("recipients must not be null");
        }
        this.mRecipients.addAll(recipients);
    }

    public void setSender(String sender) {
        if (sender == null) {
            throw new IllegalArgumentException("sender must not be null");
        }
        this.mSender = sender;
    }

    public void setSubject(String subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        this.mSubject = subject;
    }

    public void setServer(String server) {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        this.mServer = server;
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<deliverToSMTP name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<fromLocal from=\"");
        sb.append(super.replaceSpecialCharacters(super.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        Iterator iterator = this.mRecipients.iterator();
        while (iterator.hasNext()) {
            String recipient = (String)iterator.next();
            sb.append("<to>" + super.replaceSpecialCharacters(recipient) + "</to>\n");
        }
        sb.append("<from>");
        sb.append(this.replaceSpecialCharacters(this.mSender));
        sb.append("</from>\n");
        sb.append("<subject>");
        sb.append(this.replaceSpecialCharacters(this.mSubject));
        sb.append("</subject>\n");
        sb.append("<server>");
        sb.append(this.replaceSpecialCharacters(this.mServer));
        sb.append("</server>\n");
        sb.append("</deliverToSMTP>");
        return sb.toString();
    }
}

