/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import javax.xml.namespace.QName;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.sessions.SessionID;

public class DeliverToResourceProperty
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private QName mResourcePropertyName;
    private boolean mIsSessionSpecific = true;

    public DeliverToResourceProperty(QName resourcePropertyName) {
        this.addInput("input");
        this.setResourcePropertyName(resourcePropertyName);
        this.mIsSessionSpecific = true;
    }

    public void setResourcePropertyName(QName resourcePropertyName) {
        if (resourcePropertyName == null) {
            throw new IllegalArgumentException("resourcePropertyName must not be null");
        }
        this.mResourcePropertyName = resourcePropertyName;
    }

    public QName getResourcePropertyName() {
        return this.mResourcePropertyName;
    }

    public QName getResourcePropertyName(SessionID sessionID) {
        return new QName(this.mResourcePropertyName.getNamespaceURI(), this.mResourcePropertyName.getLocalPart() + "-" + sessionID);
    }

    public void setSessionSpecific(boolean sessionSpecific) {
        this.mIsSessionSpecific = sessionSpecific;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<deliverToResourceProperty name=\"");
        xml.append(this.getName());
        xml.append("\">\n");
        xml.append("<input from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        xml.append("<resourceProperty name=\"");
        xml.append(this.mResourcePropertyName.getLocalPart());
        xml.append("\" ns=\"");
        xml.append(this.mResourcePropertyName.getNamespaceURI());
        xml.append("\" sessionSpecific=\"");
        xml.append(this.mIsSessionSpecific);
        xml.append("\"/>\n");
        xml.append("</deliverToResourceProperty>");
        return xml.toString();
    }
}

