/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import java.net.URL;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.ServiceType;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.delivery.DataTransportMode;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIAuthorizationType;
import uk.org.ogsadai.client.toolkit.security.wsrf.GSIProtectionLevel;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.sessions.SessionStreamID;

public class DeliverToDT
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    protected URL mURL;
    protected ResourceID mResourceID;
    protected SessionStreamID mStreamID;
    protected ServiceType mServiceType = null;
    protected DataTransportMode mMode = DataTransportMode.FULL;
    protected GSIProtectionLevel mProtectionLevel;
    protected GSIAuthorizationType mAuthorizationType;

    public DeliverToDT() {
        this.addInput("DeliverToGDTInput");
    }

    public DeliverToDT(URL url, ResourceID resourceID, SessionStreamID streamID, DataTransportMode mode) {
        this();
        this.setDataTransportURL(url);
        this.setDataTransportResourceID(resourceID);
        this.setDataTransportStreamID(streamID);
        this.setDataTransportMode(mode);
    }

    public void setDataTransportOutput(DataTransport service) {
        if (service == null) {
            throw new IllegalArgumentException("service must not be null");
        }
        this.setDataTransportURL(service.getDataTransportURL());
        this.setDataTransportResourceID(service.getResourceID());
        this.setDataTransportStreamID(service.getSessionStreamID());
    }

    public void setDataTransportURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        this.mURL = url;
    }

    public void setDataTransportResourceID(ResourceID id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.mResourceID = id;
    }

    public void setDataTransportStreamID(SessionStreamID streamID) {
        if (streamID == null) {
            throw new IllegalArgumentException("streamID must not be null");
        }
        this.mStreamID = streamID;
    }

    public void setServiceType(ServiceType serviceType) {
        this.mServiceType = serviceType;
    }

    public void setDataTransportMode(DataTransportMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        this.mMode = mode;
    }

    public void setGSISecureConversation(GSIProtectionLevel protectionLevel, GSIAuthorizationType authorizationType) {
        this.mProtectionLevel = protectionLevel;
        this.mAuthorizationType = authorizationType;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<deliverToGDT name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<fromLocal from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("<toGDT ");
        if (this.mServiceType != null) {
            sb.append("serviceType=\"");
            sb.append(this.replaceSpecialCharacters(this.mServiceType.getAsString()));
            sb.append("\" ");
        }
        sb.append("streamId=\"");
        sb.append(this.replaceSpecialCharacters(this.mStreamID.getCompoundID()));
        sb.append("\" ");
        sb.append("resourceName=\"");
        sb.append(this.replaceSpecialCharacters(this.mResourceID.getName()));
        sb.append("\" ");
        sb.append("mode=\"");
        sb.append(this.mMode.getAsString());
        sb.append("\" >");
        sb.append(this.replaceSpecialCharacters(this.mURL.toString()));
        sb.append("</toGDT>");
        if (this.mProtectionLevel != null) {
            sb.append("<GSISecureConversation ");
            sb.append("protectionLevel=\"");
            sb.append(this.mProtectionLevel.toString());
            sb.append("\" authorization=\"");
            sb.append(this.mAuthorizationType.toString());
            sb.append("\" />");
        }
        sb.append("</deliverToGDT>");
        return sb.toString();
    }
}

