/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import java.net.URI;
import java.net.URISyntaxException;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class DeliverFromURL
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mURI = "";
    private int mNoOfBytesToBlock = -1;

    public DeliverFromURL() {
        this.addOutput("deliverFromURLOutput");
    }

    public DeliverFromURL(String url) {
        this();
        this.setURL(url);
    }

    public DeliverFromURL(String url, int noOfBytesInBlock) {
        this();
        this.setURL(url);
        this.setBlockSize(noOfBytesInBlock);
    }

    public void setURL(String url) {
        if (url == null || url.trim().equals("")) {
            throw new IllegalArgumentException("url must not be null or ''");
        }
        try {
            URI urlTest = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("url must be a legal URI or URL : " + url);
        }
        this.mURI = url;
    }

    public void setBlockSize(int noOfBytesInBlock) {
        if (noOfBytesInBlock <= 0) {
            throw new IllegalArgumentException("noOfBytesInBlock must be > 0");
        }
        this.mNoOfBytesToBlock = noOfBytesInBlock;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<deliverFromURL name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<fromURL");
        if (this.mNoOfBytesToBlock != -1) {
            sb.append(" blockSizeInBytes=\"");
            sb.append(this.mNoOfBytesToBlock);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(this.replaceSpecialCharacters(this.mURI));
        sb.append("</fromURL>");
        sb.append("<toLocal name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</deliverFromURL>");
        return sb.toString();
    }
}

