/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public class DeliverFromFile
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mFile = "";
    private int mNoOfBytesToBlock = -1;

    public DeliverFromFile() {
        this.addOutput("deliverFromFileOutput");
    }

    public DeliverFromFile(String file) {
        this();
        this.setFile(file);
    }

    public DeliverFromFile(String file, int noOfBytesInBlock) {
        this();
        this.setFile(file);
        this.setBlockSize(noOfBytesInBlock);
    }

    public void setFile(String file) {
        if (file == null || file.trim().equals("")) {
            throw new IllegalArgumentException("file must not be null or ''");
        }
        this.mFile = file;
    }

    public void setBlockSize(int noOfBytesInBlock) {
        if (noOfBytesInBlock <= 0) {
            throw new IllegalArgumentException("noOfBytesInBlock must be > 0");
        }
        this.mNoOfBytesToBlock = noOfBytesInBlock;
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<deliverFromFile name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<fromFile");
        if (this.mNoOfBytesToBlock != -1) {
            sb.append(" blockSizeInBytes=\"");
            sb.append(this.mNoOfBytesToBlock);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(this.replaceSpecialCharacters(this.mFile));
        sb.append("</fromFile>");
        sb.append("<toLocal name=\"");
        sb.append(this.getOutputs()[0].getName());
        sb.append("\"/>\n");
        sb.append("</deliverFromFile>");
        return sb.toString();
    }
}

