/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import java.util.NoSuchElementException;
import uk.org.ogsadai.client.toolkit.activity.delivery.StreamDataException;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.service.ServiceConstants;
import uk.org.ogsadai.common.BlockReader;

public class DataTransportBlockReader
implements BlockReader {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) The University of Edinburgh 2002 - 2006";
    private Object mNextBlock;
    private final int mBlocksToFetch;
    private final DataTransport mService;

    public DataTransportBlockReader(DataTransport service) throws StreamDataException {
        this(service, 1);
    }

    public DataTransportBlockReader(DataTransport service, int blocksToFetch) throws StreamDataException {
        if (service == null) {
            throw new IllegalArgumentException("service must not be null");
        }
        if (blocksToFetch <= 0) {
            throw new IllegalArgumentException("blocksToFetch must be > 0");
        }
        this.mBlocksToFetch = blocksToFetch;
        this.mService = service;
        this.mNextBlock = this.fetchBlock();
    }

    public boolean hasNext() {
        return this.mNextBlock != null;
    }

    public Object next() {
        try {
            Object ret = this.mNextBlock;
            this.mNextBlock = this.fetchBlock();
            return ret;
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getLocalizedMessage());
        }
    }

    public Object fetchBlock() throws StreamDataException {
        Object nBlocks = null;
        try {
            nBlocks = this.mService.getNBlocks(this.mBlocksToFetch);
        }
        catch (Exception e) {
            throw new StreamDataException(e);
        }
        if (nBlocks != null && nBlocks.equals(ServiceConstants.NO_MORE_DATA)) {
            nBlocks = null;
        }
        return nBlocks;
    }
}

