/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity.delivery;

import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.delivery.DataTransportBlockReader;
import uk.org.ogsadai.client.toolkit.activity.delivery.StreamDataException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionStreamID;
import uk.org.ogsadai.common.BlockReaderReader;
import uk.org.ogsadai.converters.webrowset.resultset.WebRowSetToResultSet;

public class DTOutputStream
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";

    public DTOutputStream() {
        this.addInput("outputStreamActivityInput");
    }

    public DTOutputStream(ActivityOutput input) {
        this();
        this.setInput(input);
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public DataTransport getDataTransport() {
        Session session = this.getSession();
        SessionStreamID sessionStreamID = new SessionStreamID(session.getSessionID(), this.getName());
        DataTransport dataTransport = this.getDataService().createDataTransport(this.getDataResourceID(), sessionStreamID);
        return dataTransport;
    }

    public Session getSession() {
        try {
            return super.getSession();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("The DataTransport object cannot be retrieved before the request containing this activity has been sent to the data service and the response has been received.");
        }
    }

    protected String generateXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<outputStream name=\"");
        sb.append(this.getName());
        sb.append("\">\n");
        sb.append("<fromLocal from=\"");
        sb.append(this.replaceSpecialCharacters(this.getInputParameters()[0].getOutputName()));
        sb.append("\"/>\n");
        sb.append("</outputStream>");
        return sb.toString();
    }

    public ResultSet getResultSet() throws StreamDataException, DataFormatException {
        return this.getResultSet(1);
    }

    public ResultSet getResultSet(int numberOfRowsToFetch) throws StreamDataException, DataFormatException {
        DataTransportBlockReader fromDT = new DataTransportBlockReader(this.getDataTransport(), numberOfRowsToFetch);
        if (!fromDT.hasNext()) {
            throw new DataFormatException("WebRowSetToResultSet", "null");
        }
        try {
            WebRowSetToResultSet converter = new WebRowSetToResultSet(new BlockReaderReader(fromDT));
            converter.setResultSetType(1003);
            return converter.getResultSet();
        }
        catch (Exception e) {
            throw new DataFormatException(e);
        }
    }
}

