/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.Map;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.common.UniqueName;

public abstract class RequestComponent {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private String mName = this.getClassName() + "-" + UniqueName.getInstance().getName();
    private ResourceID mResource;
    private DataService mDataService;
    private Session mSession;

    private String getClassName() {
        int dotIndex;
        String fullName = this.getClass().getName();
        String unqualName = fullName.substring((dotIndex = fullName.lastIndexOf(".")) + 1);
        int dollarIndex = unqualName.lastIndexOf("$");
        if (dollarIndex != -1) {
            return unqualName.substring(dollarIndex + 1);
        }
        return unqualName;
    }

    public String getName() {
        return this.mName;
    }

    protected ResourceID getDataResourceID() {
        return this.mResource;
    }

    protected void setDataResourceID(ResourceID id) {
        this.mResource = id;
    }

    protected void setSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("The session argument must not be null.");
        }
        this.mSession = session;
    }

    protected Session getSession() throws IllegalStateException {
        if (this.mSession == null) {
            throw new IllegalStateException("The getSession method cannot be used before the setSession method has been invoked.");
        }
        return this.mSession;
    }

    protected void setDataService(DataService dataService) {
        this.mDataService = dataService;
    }

    protected DataService getDataService() {
        return this.mDataService;
    }

    protected abstract String generateXML();

    protected abstract void addOutputs(Map var1);
}

