/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;

public abstract class ParameterizedActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private Map mParameters = new TreeMap();
    private String mElementName;

    protected ParameterizedActivity(String elementName) {
        this.mElementName = elementName;
    }

    public void setParameter(int index, String value) {
        if (index < 1) {
            throw new IndexOutOfBoundsException("index must be >= 1. It was " + index);
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.mParameters.put(new Integer(index), value);
    }

    public void setParameter(int index, ActivityOutput output) {
        if (index < 1) {
            throw new IndexOutOfBoundsException("index must be >= 1. It was " + index);
        }
        if (output == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.mParameters.put(new Integer(index), output);
    }

    public void clearParameters() {
        this.mParameters.clear();
    }

    protected String generateParametersXML() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.mParameters.keySet().iterator();
        while (i.hasNext()) {
            ActivityOutput output;
            String value;
            Integer key = (Integer)i.next();
            Object param = this.mParameters.get(key);
            if (param instanceof String) {
                value = (String)param;
                output = null;
            } else {
                value = null;
                output = (ActivityOutput)param;
            }
            sb.append("<");
            sb.append(this.mElementName);
            sb.append(" position=\"");
            sb.append(key);
            if (value != null) {
                sb.append("\">");
                sb.append(this.replaceSpecialCharacters(value));
                sb.append("</");
                sb.append(this.mElementName);
            } else {
                sb.append("\" from=\"");
                sb.append(output.getName());
                sb.append("\"/");
            }
            sb.append(">\n");
        }
        return sb.toString();
    }
}

