/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import org.w3c.dom.Element;
import uk.org.ogsadai.client.toolkit.activity.Activity;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.NoActivityOutputException;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;

public class ExampleActivity
extends Activity {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private String mSettingA;
    private int mSettingB;
    private String mSettingC;

    public ExampleActivity(String settingA, int settingB) {
        this.addInput("DisplayNameForInput");
        this.addOutput("DisplayNameForOutput");
        this.mSettingA = settingA;
        this.mSettingB = settingB;
    }

    public void setSettingC(String setting) {
        if (setting == null) {
            throw new IllegalArgumentException("setting must not be null");
        }
        this.mSettingC = setting;
    }

    public final void setInput(ActivityOutput input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        super.setInput(0, input.getName());
    }

    public ActivityOutput getOutput() {
        return this.getOutputs()[0];
    }

    public int getSomething() throws DataFormatException, NoActivityOutputException {
        int something = 0;
        ActivityOutput output = this.getOutputs()[0];
        String outputData = output.getData();
        try {
            Element element = XMLUtilities.xmlStringToDOM(outputData, false).getDocumentElement();
            something = Integer.parseInt(element.getAttribute("someAttribute"));
        }
        catch (DAIException e) {
            throw new DataFormatException("someAttribute", outputData, e);
        }
        return something;
    }

    protected String generateXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<activityElement>\n");
        xml.append("<input from=\"");
        xml.append(this.getInputParameters()[0].getOutputName());
        xml.append("\"/>\n");
        xml.append("  <settings a=\"");
        xml.append(this.mSettingA);
        xml.append("\" b=\"");
        xml.append(this.mSettingB);
        xml.append("\"/>\n");
        if (this.mSettingC != null) {
            xml.append("  <optionalSetting>");
            xml.append(this.mSettingC);
            xml.append("</optionalSetting>");
        }
        xml.append("  <output name=\"");
        xml.append(this.getOutputParameters()[0].getName());
        xml.append("\"/>\n");
        xml.append("</activityElement>");
        return xml.toString();
    }
}

