/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionImpl;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.xml.XMLUtilities;

final class ActivityResponse
implements Response {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private Document mResponseDocument;
    private final Session mSession;
    private final RequestStatus mRequestStatus;
    private final AttachmentManager mAttachmentManager;

    ActivityResponse(DataService dataService, Document response, Map outputs) throws DataFormatException {
        this(dataService, response, outputs, null);
    }

    ActivityResponse(DataService dataService, Document response, Map outputs, AttachmentManager attachmentManager) throws DataFormatException {
        this.mResponseDocument = response;
        this.mSession = new SessionImpl(dataService, response);
        this.mRequestStatus = RequestStatus.createFromResponse(response);
        NodeList results = response.getDocumentElement().getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/types", "result");
        int numResults = results.getLength();
        for (int i = 0; i < numResults; ++i) {
            String data;
            Node dataNode;
            Element result = (Element)results.item(i);
            String name = result.getAttribute("name");
            ActivityOutput output = (ActivityOutput)outputs.get(name);
            if (output == null || (dataNode = result.getFirstChild()) == null || (data = dataNode.getNodeValue()) == null) continue;
            output.setData(data);
        }
        this.mAttachmentManager = attachmentManager;
    }

    public Document getDocument() {
        return this.mResponseDocument;
    }

    public String getAsString() {
        return XMLUtilities.xmlDOMToString(this.mResponseDocument);
    }

    public String toString() {
        String result = "[ActivityResponse: hashCode=" + this.hashCode() + " ]";
        return result;
    }

    public Session getSession() {
        return this.mSession;
    }

    public RequestStatus getRequestStatus() {
        return this.mRequestStatus;
    }

    public AttachmentManager getAttachmentManager() {
        return this.mAttachmentManager;
    }
}

