/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityResponse;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.exception.PerformDocumentException;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.NoSessionRequirements;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionRequirements;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;

public class ActivityRequest
extends Request {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final String HEADER = "<?xml version=\"1.0\"?>\n<perform xmlns=\"http://ogsadai.org.uk/namespaces/2005/10/types\">\n";
    private static final String FOOTER = "</perform>";
    private List mComponents = new ArrayList();
    private Map mOutputs = new HashMap();
    private SessionRequirements mSessionRequirements = new NoSessionRequirements();

    public ActivityRequest() {
    }

    public ActivityRequest(RequestComponent[] components) {
        this.add(components);
    }

    public void add(RequestComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        this.mComponents.add(component);
    }

    public void add(RequestComponent[] components) {
        if (components == null) {
            throw new IllegalArgumentException("components must not be null");
        }
        int numComponents = components.length;
        for (int i = 0; i < numComponents; ++i) {
            this.add(components[i]);
        }
    }

    public void clear() {
        this.mComponents.clear();
        this.mOutputs.clear();
    }

    public String toString() {
        String result = "[ActivityRequest: #activities=" + this.mComponents.size() + " ]";
        return result;
    }

    public Response createResponse(Document responseDocument) throws DataFormatException {
        ActivityResponse response = new ActivityResponse(this.getDataService(), responseDocument, this.mOutputs);
        this.setRequestComponentSession(response.getSession());
        return response;
    }

    public Response createResponse(Document responseDocument, AttachmentManager attachmentManager) throws DataFormatException {
        ActivityResponse response = new ActivityResponse(this.getDataService(), responseDocument, this.mOutputs, attachmentManager);
        this.setRequestComponentSession(response.getSession());
        return response;
    }

    private void setRequestComponentSession(Session session) {
        Iterator i = this.mComponents.iterator();
        while (i.hasNext()) {
            RequestComponent component = (RequestComponent)i.next();
            component.setSession(session);
        }
    }

    public void setDataResourceID(ResourceID id) {
        Iterator iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            RequestComponent component = (RequestComponent)iterator.next();
            component.setDataResourceID(id);
        }
    }

    public void setDataService(DataService dataService) {
        super.setDataService(dataService);
        Iterator i = this.mComponents.iterator();
        while (i.hasNext()) {
            RequestComponent component = (RequestComponent)i.next();
            component.setDataService(dataService);
        }
    }

    public Document getDocument() {
        this.constructOutputsMap();
        StringBuffer sb = new StringBuffer();
        sb.append(HEADER);
        sb.append(this.mSessionRequirements.generateXML());
        Iterator i = this.mComponents.iterator();
        while (i.hasNext()) {
            RequestComponent component = (RequestComponent)i.next();
            sb.append(component.generateXML());
        }
        sb.append(FOOTER);
        try {
            return XMLUtilities.xmlStringToDOM(sb.toString(), false);
        }
        catch (DAIException e) {
            throw new PerformDocumentException(e);
        }
    }

    private void constructOutputsMap() {
        Iterator iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            RequestComponent component = (RequestComponent)iterator.next();
            component.addOutputs(this.mOutputs);
        }
    }

    public void setSessionRequirements(SessionRequirements requirements) {
        if (requirements == null) {
            throw new IllegalArgumentException("requirements must not be null");
        }
        this.mSessionRequirements = requirements;
    }
}

