/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputParameter;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputParameterImpl;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputParameterInternal;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutputParameter;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutputParameterImpl;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutputParameterInternal;
import uk.org.ogsadai.client.toolkit.activity.RequestComponent;

public abstract class Activity
extends RequestComponent {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private List mInputParams = new ArrayList();
    private List mOutputParams = new ArrayList();

    protected Activity() {
    }

    protected ActivityInputParameterInternal addInput(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName must not be null");
        }
        ActivityInputParameterImpl param = new ActivityInputParameterImpl(parameterName);
        this.mInputParams.add(param);
        return param;
    }

    protected ActivityOutputParameterInternal addOutput(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("parameterName must not be null");
        }
        ActivityOutputParameterImpl param = new ActivityOutputParameterImpl(parameterName);
        this.mOutputParams.add(param);
        return param;
    }

    protected ActivityOutput[] getOutputs() {
        ActivityOutput[] result = new ActivityOutput[this.mOutputParams.size()];
        int numOutputs = this.mOutputParams.size();
        for (int i = 0; i < numOutputs; ++i) {
            ActivityOutputParameterInternal outputParam = (ActivityOutputParameterInternal)this.mOutputParams.get(i);
            result[i] = outputParam.getOutput();
        }
        return result;
    }

    public ActivityInputParameter[] getInputParameters() {
        return this.mInputParams.toArray(new ActivityInputParameter[0]);
    }

    public ActivityOutputParameter[] getOutputParameters() {
        return this.mOutputParams.toArray(new ActivityOutputParameter[0]);
    }

    public void setInput(int index, String outputName) {
        if (outputName == null) {
            throw new IllegalArgumentException("outputName must not be null");
        }
        if (index < 0 || index >= this.mInputParams.size()) {
            throw new IndexOutOfBoundsException("index must be >=0 and <= " + this.mInputParams.size() + " : " + index);
        }
        ActivityInputParameterInternal param = (ActivityInputParameterInternal)this.mInputParams.get(index);
        param.setOutputName(outputName);
    }

    protected void setDataResourceID(ResourceID id) {
        super.setDataResourceID(id);
    }

    protected ResourceID getDataResourceID() {
        return super.getDataResourceID();
    }

    protected abstract String generateXML();

    protected String replaceSpecialCharacters(String input) {
        input = input.replaceAll("&", "&amp;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll("\"", "&quot;");
        input = input.replaceAll("'", "&apos;");
        return input;
    }

    protected void addOutputs(Map allOutputs) {
        ActivityOutput[] outputs = this.getOutputs();
        if (outputs != null) {
            int numOutputs = outputs.length;
            for (int i = 0; i < numOutputs; ++i) {
                allOutputs.put(outputs[i].getName(), outputs[i]);
            }
        }
    }
}

