/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

public final class ServiceType {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final String WSI_STRING = "wsi";
    private static final String WSRF_STRING = "wsrf";
    private static final String UNKNOWN_STRING = "unknown";
    public static final ServiceType WSI = new ServiceType("wsi");
    public static final ServiceType WSRF = new ServiceType("wsrf");
    public static final ServiceType UNKNOWN = new ServiceType("unknown");
    private String mType = "unknown";

    private ServiceType(String type) {
        this.setType(type);
    }

    public void setType(String type) {
        if (type == null || !type.equals(WSI_STRING) && !type.equals(WSRF_STRING) && !type.equals(UNKNOWN_STRING)) {
            throw new IllegalArgumentException("type must be one of ServiceType.WSI_STRING, ServiceType.WSRF_STRING or ServiceType.UNKNOWN_STRING : " + type);
        }
        this.mType = type;
    }

    public void setWSI() {
        this.setType(WSI_STRING);
    }

    public void setWSRF() {
        this.setType(WSRF_STRING);
    }

    public void setUnknown() {
        this.setType(UNKNOWN_STRING);
    }

    public boolean isWSI() {
        return WSI_STRING.equals(this.mType);
    }

    public boolean isWSRF() {
        return WSRF_STRING.equals(this.mType);
    }

    public boolean isUnknown() {
        return UNKNOWN_STRING.equals(this.mType);
    }

    public String getAsString() {
        return this.mType;
    }
}

