/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import uk.org.ogsadai.client.toolkit.SimpleResourceIDImpl;
import uk.org.ogsadai.client.toolkit.exception.ServiceCommsException;
import uk.org.ogsadai.client.toolkit.service.ConfigurableDataService;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.service.ServiceFetcher;
import uk.org.ogsadai.client.toolkit.service.ServiceTypeException;
import uk.org.ogsadai.client.toolkit.wsi.ConfigurableWSIDataService;
import uk.org.ogsadai.client.toolkit.wsi.WSIDataService;
import uk.org.ogsadai.client.toolkit.wsrf.ConfigurableWSRFDataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFDataService;

public class GenericServiceFetcher
implements ServiceFetcher {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005";
    private static GenericServiceFetcher mInstance;

    public static GenericServiceFetcher getInstance() {
        if (mInstance == null) {
            mInstance = new GenericServiceFetcher();
        }
        return mInstance;
    }

    public DataService getDataService(String url, String resourceID) throws MalformedURLException, IllegalArgumentException, ServiceCommsException, ServiceTypeException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        return this.findDataService(url, resourceID);
    }

    public ConfigurableDataService getConfigurableDataService(String url, String resourceID) throws MalformedURLException, IllegalArgumentException, ServiceCommsException, ServiceTypeException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        return this.findConfigurableDataService(url, resourceID);
    }

    public WSRFDataService getWSRFDataService(String url, String resourceID) throws IllegalArgumentException, MalformedURLException {
        return new WSRFDataService(url, new SimpleResourceIDImpl(resourceID));
    }

    public WSIDataService getWSIDataService(String url, String resourceID) throws IllegalArgumentException, MalformedURLException {
        return new WSIDataService(url, new SimpleResourceIDImpl(resourceID));
    }

    private DataService findDataService(String url, String resourceID) throws MalformedURLException, IllegalArgumentException, ServiceCommsException, ServiceTypeException {
        String wsdl;
        URL urlWSDL = new URL(url + "?WSDL");
        try {
            wsdl = this.getWSDL(urlWSDL);
        }
        catch (IOException e) {
            throw new ServiceCommsException(url + "?WSDL", e);
        }
        SimpleResourceIDImpl resource = new SimpleResourceIDImpl(resourceID);
        if (this.isWSRF(wsdl)) {
            return new WSRFDataService(url, resource);
        }
        if (this.isWSI(wsdl)) {
            return new WSIDataService(url, resource);
        }
        throw new ServiceTypeException(new URL(url));
    }

    private ConfigurableDataService findConfigurableDataService(String url, String resourceID) throws MalformedURLException, IllegalArgumentException, ServiceCommsException, ServiceTypeException {
        String wsdl;
        URL urlWSDL = new URL(url + "?WSDL");
        try {
            wsdl = this.getWSDL(urlWSDL);
        }
        catch (IOException e) {
            throw new ServiceCommsException(url + "?WSDL", e);
        }
        SimpleResourceIDImpl resource = new SimpleResourceIDImpl(resourceID);
        if (this.isWSRF(wsdl)) {
            return new ConfigurableWSRFDataService(url, resource);
        }
        if (this.isWSI(wsdl)) {
            return new ConfigurableWSIDataService(url, resource);
        }
        throw new ServiceTypeException(new URL(url));
    }

    private String getWSDL(URL url) throws IOException {
        int readBytes;
        InputStreamReader input = new InputStreamReader(url.openStream());
        StringBuffer buf = new StringBuffer();
        char[] charArray = new char[1024];
        while ((readBytes = input.read(charArray)) >= 0) {
            buf.append(charArray, 0, readBytes);
        }
        String wsdl = buf.toString();
        return wsdl;
    }

    private boolean isWSRF(String wsdl) {
        return wsdl.indexOf("targetNamespace=\"http://ogsadai.org.uk/namespaces/2005/10/service/wsrf/dataservice/service\"") >= 0;
    }

    private boolean isWSI(String wsdl) {
        return wsdl.indexOf("targetNamespace=\"http://ogsadai.org.uk/namespaces/2005/10/service/wsi/dataservice/service\"") >= 0;
    }
}

