/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import org.w3c.dom.Document;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.properties.RequestStatus;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.sessions.Session;
import uk.org.ogsadai.client.toolkit.sessions.SessionImpl;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.xml.XMLUtilities;

final class DocumentResponse
implements Response {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private Document mResponseDocument;
    private final Session mSession;
    private final RequestStatus mRequestStatus;
    private final AttachmentManager mAttachmentManager;

    public DocumentResponse(DataService dataService, Document response) throws DataFormatException {
        this(dataService, response, null);
    }

    public DocumentResponse(DataService dataService, Document response, AttachmentManager attachmentManager) throws DataFormatException {
        this.mResponseDocument = response;
        this.mSession = new SessionImpl(dataService, response);
        this.mRequestStatus = RequestStatus.createFromResponse(response);
        this.mAttachmentManager = attachmentManager;
    }

    public Document getDocument() {
        return this.mResponseDocument;
    }

    public String getAsString() {
        return XMLUtilities.xmlDOMToString(this.mResponseDocument);
    }

    public Session getSession() {
        return this.mSession;
    }

    public RequestStatus getRequestStatus() {
        return this.mRequestStatus;
    }

    public AttachmentManager getAttachmentManager() {
        return this.mAttachmentManager;
    }
}

