/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.io.File;
import org.w3c.dom.Document;
import uk.org.ogsadai.client.toolkit.DocumentResponse;
import uk.org.ogsadai.client.toolkit.Request;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.exception.DataFormatException;
import uk.org.ogsadai.client.toolkit.soap.AttachmentManager;
import uk.org.ogsadai.common.xml.XMLFileException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;

public class DocumentRequest
extends Request {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private Document mPerformDoc;

    public DocumentRequest(Document performDoc) {
        if (performDoc == null) {
            throw new IllegalArgumentException("performDoc must not be null");
        }
        this.mPerformDoc = performDoc;
    }

    public DocumentRequest(String performDoc) throws XMLParseException {
        if (performDoc == null) {
            throw new IllegalArgumentException("performDoc must not be null");
        }
        this.mPerformDoc = XMLUtilities.xmlStringToDOM(performDoc, false);
    }

    public DocumentRequest(File performDocFile) throws XMLFileException, XMLParseException {
        if (performDocFile == null) {
            throw new IllegalArgumentException("performDocFile must not be null");
        }
        this.mPerformDoc = XMLUtilities.xmlFileToDOM(performDocFile.toString(), false);
    }

    public String toString() {
        return XMLUtilities.xmlDOMToString(this.mPerformDoc);
    }

    public void setDataResourceID(ResourceID id) {
    }

    public Response createResponse(Document response) throws DataFormatException {
        return new DocumentResponse(this.getDataService(), response);
    }

    public Response createResponse(Document response, AttachmentManager attachmentManager) throws DataFormatException {
        return new DocumentResponse(this.getDataService(), response, attachmentManager);
    }

    public Document getDocument() {
        return this.mPerformDoc;
    }
}

