/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.monitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import uk.org.ogsadai.client.monitor.DataServiceStatus;
import uk.org.ogsadai.client.toolkit.ResourceID;

public class ServiceStatusView
implements Observer,
ActionListener {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private DataServiceStatus mDataServiceStatus;
    private JPanel mStatusPanel = new JPanel();
    private JLabel mStatus;
    private JLabel mVersion;
    private JComboBox mResources;
    private JTextPane mError;

    public ServiceStatusView(DataServiceStatus status) {
        this.mStatusPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = new JLabel(status.getServiceURL());
        TitledBorder title = BorderFactory.createTitledBorder("Service URL");
        label.setBorder(title);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.weightx = 0.2;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 10, 0, 10);
        this.mStatusPanel.add((Component)label, constraints);
        this.mResources = new JComboBox();
        this.mResources.addActionListener(this);
        JScrollPane pane = new JScrollPane(this.mResources);
        title = BorderFactory.createTitledBorder("Data Resources");
        pane.setBorder(title);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(0, 10, 0, 10);
        this.mStatusPanel.add((Component)pane, constraints);
        this.mDataServiceStatus = status;
        this.mDataServiceStatus.addObserver(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 0.1;
        JLabel statusLabel = new JLabel("Service Status", 4);
        this.mStatusPanel.add((Component)statusLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 10, 0, 10);
        this.mStatus = new JLabel("UNKNOWN", 0);
        this.mStatus.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mStatusPanel.add((Component)this.mStatus, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.5;
        constraints.weighty = 0.1;
        JLabel versionLabel = new JLabel("Service Version", 4);
        this.mStatusPanel.add((Component)versionLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.weightx = 0.5;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 10, 0, 10);
        this.mVersion = new JLabel("UNKNOWN", 0);
        this.mVersion.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mStatusPanel.add((Component)this.mVersion, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.weighty = 0.2;
        constraints.fill = 1;
        this.mError = new JTextPane();
        pane = new JScrollPane(this.mError);
        this.mError.setEditable(false);
        title = BorderFactory.createTitledBorder("Error messages");
        pane.setBorder(title);
        this.mStatusPanel.add((Component)pane, constraints);
    }

    public JPanel getStatusPanel() {
        return this.mStatusPanel;
    }

    public void update(Observable observable, Object obj) {
        if (obj == this.mDataServiceStatus) {
            this.mStatus.setText(this.mDataServiceStatus.getServiceStatus());
            this.mStatus.setOpaque(true);
            this.mStatus.setBackground(this.mStatusPanel.getBackground());
            if (this.mDataServiceStatus.getServiceStatus().equals("AVAILABLE")) {
                this.mStatus.setBackground(Color.GREEN);
            } else if (this.mDataServiceStatus.getServiceStatus().equals("NOT AVAILABLE")) {
                this.mStatus.setBackground(Color.RED);
            }
            this.mStatus.repaint();
            this.mVersion.setText(this.mDataServiceStatus.getServiceVersion());
            this.mError.setText(this.mDataServiceStatus.getErrorMessage());
            if (this.mDataServiceStatus.getDataResources() != null) {
                ResourceID selected = (ResourceID)this.mResources.getSelectedItem();
                this.mResources.removeAllItems();
                ResourceID[] resources = this.mDataServiceStatus.getDataResources();
                for (int i = 0; i < resources.length; ++i) {
                    this.mResources.addItem(resources[i]);
                }
                this.mResources.getModel().setSelectedItem(selected);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        JComboBox cb = (JComboBox)event.getSource();
        Object selectedItem = cb.getSelectedItem();
        if (selectedItem != null) {
            this.mDataServiceStatus.setResourceID((ResourceID)selectedItem);
        }
    }
}

