/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.monitor;

import java.util.Observable;
import java.util.Observer;
import uk.org.ogsadai.client.toolkit.GenericServiceFetcher;
import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.properties.DAIVersion;
import uk.org.ogsadai.client.toolkit.service.DataService;

public class DataServiceStatus {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private DataService mDataService;
    private String mServiceURL;
    private ResourceID mResource;
    private String mServiceStatus = "UNKNOWN";
    private String mVersion = "UNKNOWN";
    private String mErrorMsg = "";
    private ResourceID[] mDataResources;
    private DataServiceStatusObservable mObservable = new DataServiceStatusObservable();
    public static final String UNKNOWN = "UNKNOWN";
    public static final String SERVICE_AVAILABLE = "AVAILABLE";
    public static final String SERVICE_NOT_AVAILABLE = "NOT AVAILABLE";

    public DataServiceStatus(String url) {
        this.mServiceURL = url;
        this.mResource = null;
    }

    public void setResourceID(ResourceID id) {
        this.mResource = id;
    }

    public void addObserver(Observer observer) {
        this.mObservable.addObserver(observer);
    }

    public void updateStatus() {
        this.mErrorMsg = "";
        if (this.mDataService == null) {
            try {
                this.mDataService = GenericServiceFetcher.getInstance().getDataService(this.mServiceURL, null);
            }
            catch (Exception e) {
                this.setServiceStatusNotAvailable();
                this.mErrorMsg = e.getLocalizedMessage();
                this.mObservable.updateObservers(this);
                return;
            }
        }
        try {
            this.mDataResources = this.mDataService.getResourceIDs();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mDataService.ping();
            this.mServiceStatus = SERVICE_AVAILABLE;
        }
        catch (Exception e) {
            this.setServiceStatusNotAvailable();
            this.mErrorMsg = e.getLocalizedMessage();
            this.mObservable.updateObservers(this);
            return;
        }
        try {
            DAIVersion version = this.mDataService.getVersion();
            this.mVersion = version.toString();
        }
        catch (Exception e) {
            this.mVersion = UNKNOWN;
            this.mErrorMsg = e.getLocalizedMessage();
        }
        this.mObservable.updateObservers(this);
    }

    public String getServiceStatus() {
        return this.mServiceStatus;
    }

    public String getServiceVersion() {
        return this.mVersion;
    }

    public String getErrorMessage() {
        return this.mErrorMsg;
    }

    public String getServiceURL() {
        return this.mServiceURL;
    }

    public ResourceID getDataResource() {
        return this.mResource;
    }

    public ResourceID[] getDataResources() {
        return this.mDataResources;
    }

    private void setServiceStatusNotAvailable() {
        this.mServiceStatus = SERVICE_NOT_AVAILABLE;
        this.mVersion = UNKNOWN;
    }

    public class DataServiceStatusObservable
    extends Observable {
        public void updateObservers(Object obj) {
            this.setChanged();
            this.notifyObservers(obj);
        }
    }
}

