/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.monitor;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import uk.org.ogsadai.client.monitor.AddServiceDialog;
import uk.org.ogsadai.client.monitor.DataServiceStatus;
import uk.org.ogsadai.client.monitor.MonitorThread;
import uk.org.ogsadai.client.monitor.ServiceStatusView;

public class DataServiceMonitor
extends JFrame {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private JDesktopPane jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu windowMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem addServiceMenuItem = null;
    private List mServices = new LinkedList();
    private JMenuItem tileChildrenMenuItem = null;
    private JMenu optionsMenu = null;
    private JMenuItem timeMenuItem = null;
    private MonitorThread mMonitor;

    private JMenuItem getAddServiceMenuItem() {
        if (this.addServiceMenuItem == null) {
            this.addServiceMenuItem = new JMenuItem();
            this.addServiceMenuItem.setText("Add Service ...");
            this.addServiceMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new AddServiceDialog(DataServiceMonitor.this);
                }
            });
        }
        return this.addServiceMenuItem;
    }

    private JMenuItem getTileChildrenMenuItem() {
        if (this.tileChildrenMenuItem == null) {
            this.tileChildrenMenuItem = new JMenuItem();
            this.tileChildrenMenuItem.setText("Tile Windows");
            this.tileChildrenMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataServiceMonitor.this.tileFrames();
                }
            });
        }
        return this.tileChildrenMenuItem;
    }

    private JMenu getOptionsMenu() {
        if (this.optionsMenu == null) {
            this.optionsMenu = new JMenu();
            this.optionsMenu.setText("Options");
            this.optionsMenu.add(this.getTimeMenuItem());
        }
        return this.optionsMenu;
    }

    private JMenuItem getTimeMenuItem() {
        if (this.timeMenuItem == null) {
            this.timeMenuItem = new JMenuItem();
            this.timeMenuItem.setText("Update interval...");
            this.timeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String value = JOptionPane.showInputDialog(DataServiceMonitor.this, "Please specify an interval for updating\nthe service status (in milliseconds)", DataServiceMonitor.this.mMonitor.getInterval());
                    if (value == null || "".equals(value)) {
                        return;
                    }
                    try {
                        Long interval = new Long(value);
                        DataServiceMonitor.this.mMonitor.setInterval(interval);
                    }
                    catch (NumberFormatException err) {
                        JOptionPane.showMessageDialog(DataServiceMonitor.this, "Invalid input : " + value + "\nTime interval is " + DataServiceMonitor.this.mMonitor.getInterval() + "ms", "Invalid input", 2);
                    }
                }
            });
        }
        return this.timeMenuItem;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataServiceMonitor application = new DataServiceMonitor();
        application.show();
    }

    public DataServiceMonitor() {
        this.initialize();
        this.mMonitor = new MonitorThread(this.mServices);
        this.mMonitor.start();
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(800, 500);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Data Service Monitor");
    }

    private JDesktopPane getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JDesktopPane();
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getWindowMenu());
            this.jJMenuBar.add(this.getOptionsMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getAddServiceMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getWindowMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu();
            this.windowMenu.setText("Window");
            this.windowMenu.add(this.getTileChildrenMenuItem());
        }
        return this.windowMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new JDialog(DataServiceMonitor.this, "About", true).show();
                }
            });
        }
        return this.aboutMenuItem;
    }

    private void tileFrames() {
        JInternalFrame[] frames = this.jContentPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        Rectangle dtbounds = this.jContentPane.getBounds();
        int width = dtbounds.width / frames.length;
        for (int i = 0; i < frames.length; ++i) {
            frames[i].setBounds(i * width, 0, width, dtbounds.height);
        }
    }

    public void addDataService(String name, String url) {
        JInternalFrame frame = new JInternalFrame();
        DataServiceStatus status = new DataServiceStatus(url);
        ServiceStatusView view = new ServiceStatusView(status);
        frame.getContentPane().add(view.getStatusPanel());
        frame.setTitle(name);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setClosable(true);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent event) {
                JInternalFrame[] frames = DataServiceMonitor.this.jContentPane.getAllFrames();
                JInternalFrame source = (JInternalFrame)event.getSource();
                for (int i = 0; i < frames.length; ++i) {
                    if (frames[i] != source) continue;
                    DataServiceMonitor.this.mServices.remove(i);
                    return;
                }
            }
        });
        frame.setIconifiable(true);
        frame.setVisible(true);
        frame.setLocation(this.mServices.size() * 20, this.mServices.size() * 20);
        frame.setSize(300, 400);
        this.jContentPane.add(frame);
        this.mServices.add(status);
        this.repaint();
        frame.toFront();
    }
}

