/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import java.lang.reflect.Array;
import java.util.Random;

public class TravelDataCreator {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static final int SEED = 10000;
    private static byte[] mRandomBytes;
    private static final int SIZE = 1000000;
    private static final String[] FIRST_NAMES;
    private static final String[] LAST_NAMES;
    private static final String[] TOWNS;
    private static final String[] ROADS;
    private static final String[] DESTINATION_NAME;
    private static final String[] PLACES;
    private static final String[] COUNTRIES;

    public TravelDataCreator() {
        Random random = new Random(10000L);
        mRandomBytes = new byte[1000000];
        random.nextBytes(mRandomBytes);
    }

    public String generatePhone(int i) {
        StringBuffer phone = new StringBuffer();
        phone.append('0');
        int[] numbers = this.chooseNumbers(i, 10);
        for (int j = 0; j < numbers.length; ++j) {
            phone.append(numbers[j]);
        }
        return phone.toString();
    }

    public String generateName(int i) {
        String name = TravelDataCreator.chooseFromArray(FIRST_NAMES, i) + " " + TravelDataCreator.chooseFromArray(LAST_NAMES, i);
        return name;
    }

    public String generateAddress(int i) {
        StringBuffer address = new StringBuffer();
        int[] number = this.chooseNumbers(i, 3);
        address.append(number[0]);
        address.append(number[1]);
        address.append(number[2]);
        address.append(" ");
        address.append(TravelDataCreator.chooseFromArray(LAST_NAMES, TravelDataCreator.chooseFromByteArray(i)));
        address.append(" ");
        address.append(TravelDataCreator.chooseFromArray(ROADS, TravelDataCreator.chooseFromByteArray(i)));
        address.append(", ");
        address.append(TravelDataCreator.chooseFromArray(TOWNS, TravelDataCreator.chooseFromByteArray(i)));
        return address.toString();
    }

    public String generateDOB(int i) {
        return this.chooseDate(i, 1940, 1990);
    }

    public int generateTraveller(long i, int maxValue) {
        int r = TravelDataCreator.chooseFromByteArray(i);
        return (int)(i + (long)r) % maxValue + 1;
    }

    public int generateDestination(long i, int maxValue) {
        int r = TravelDataCreator.chooseFromByteArray(i);
        return maxValue - (int)(i + (long)r) % maxValue;
    }

    public String generateDestinationName(int i) {
        StringBuffer dest = new StringBuffer();
        dest.append(TravelDataCreator.chooseFromArray(DESTINATION_NAME, TravelDataCreator.chooseFromByteArray(i)));
        dest.append(" ");
        dest.append(TravelDataCreator.chooseFromArray(LAST_NAMES, TravelDataCreator.chooseFromByteArray(i + 1)));
        return dest.toString();
    }

    public String generateCountry(int i) {
        return TravelDataCreator.chooseFromArray(COUNTRIES, i);
    }

    public String generateDescription(int i) {
        return "This is a description of the destination. It is human readable and contains absolutely no information.";
    }

    public byte[] generateBytes(int i, int length) {
        if (length > mRandomBytes.length) {
            throw new IllegalArgumentException("Argument length too large, must be less than 1000000");
        }
        byte[] result = new byte[length];
        int firstbyte = i % 1000000;
        if (mRandomBytes.length - firstbyte < length) {
            System.arraycopy(mRandomBytes, firstbyte, result, 0, mRandomBytes.length - firstbyte);
            System.arraycopy(mRandomBytes, 0, result, mRandomBytes.length - firstbyte + 1, length - mRandomBytes.length + firstbyte);
        } else {
            System.arraycopy(mRandomBytes, firstbyte, result, 0, length);
        }
        return result;
    }

    public String generateDepartureDate(long i) {
        return this.chooseDate(i, 2000, 2010);
    }

    public String generateDepartureTime(long i) {
        return this.chooseTime(i);
    }

    public String generateTimestamp(long i) {
        StringBuffer t = new StringBuffer();
        t.append(this.chooseDate(TravelDataCreator.chooseFromByteArray(i), 2000, 2005));
        t.append(" ");
        t.append(this.chooseTime(TravelDataCreator.chooseFromByteArray(i)));
        return t.toString();
    }

    public double generatePrice(long i) {
        int[] numbers = this.chooseNumbers(i, 5);
        StringBuffer s = new StringBuffer();
        s.append(i % 2L & i % 3L);
        s.append(numbers[0]);
        s.append(numbers[1]);
        s.append(numbers[2]);
        s.append(".");
        s.append(numbers[3]);
        s.append(numbers[4]);
        return Double.parseDouble(s.toString());
    }

    private static String chooseFromArray(String[] stringArray, int i) {
        int l = Array.getLength(stringArray);
        return stringArray[i % l];
    }

    private static int chooseFromByteArray(long i) {
        int index = Math.abs((int)i % 1000000);
        return Math.abs(mRandomBytes[index]);
    }

    private int[] chooseNumbers(long i, int length) {
        int[] result = new int[length];
        for (int j = 0; j < length; ++j) {
            result[j] = TravelDataCreator.chooseFromByteArray(i + (long)j) % 10;
        }
        return result;
    }

    private String chooseDate(long i, int minYear, int maxYear) {
        StringBuffer date = new StringBuffer();
        int diff = maxYear - minYear;
        if (diff < 0) {
            throw new IllegalArgumentException("Argument minYear must be smaller than argument maxYear");
        }
        i = Math.abs(i);
        int year = TravelDataCreator.chooseFromByteArray(i) % diff;
        int month = TravelDataCreator.chooseFromByteArray(i + 1L) % 12;
        int day = TravelDataCreator.chooseFromByteArray(i + 2L) % 28;
        date.append(minYear + year);
        date.append("-");
        date.append(month + 1);
        date.append("-");
        date.append(day + 1);
        return date.toString();
    }

    private String chooseTime(long i) {
        i = Math.abs(i);
        int hour = TravelDataCreator.chooseFromByteArray(i) % 24;
        int minute = TravelDataCreator.chooseFromByteArray(i * 2L) % 60;
        int second = TravelDataCreator.chooseFromByteArray(i * 3L) % 60;
        StringBuffer time = new StringBuffer();
        time.append(hour);
        time.append(":");
        time.append(minute);
        time.append(":");
        time.append(second);
        return time.toString();
    }

    static {
        FIRST_NAMES = new String[]{"Ali", "Ally", "Amy", "Andrew", "Charaka", "Dave", "George", "James", "Malcolm", "Mario", "Martin", "Mike", "Neil", "Norman", "Paul", "Simon", "Tom"};
        LAST_NAMES = new String[]{"Anjomshoaa", "Antonioletti", "Atkinson", "Borley", "Chue Hong", "Hardman", "Hicken", "Hume", "Jackson", "Krause", "Laws", "Magowan", "Palansuriya", "Paton", "Pearson", "Sugden", "Watson", "Westhead"};
        TOWNS = new String[]{"Edinburgh", "San Jose", "Southampton", "Winchester"};
        ROADS = new String[]{"Street", "Road", "Crescent", "Gardens", "Place", "Lane", "Avenue", "Drive"};
        DESTINATION_NAME = new String[]{"Hotel", "Beach Hotel", "Grand Hotel", "Resort", "Cottage", "Camping"};
        PLACES = new String[]{"Dark Forest", "Red Mountain", "Far Far Away", "Deep Lake", "Green Beach", "Black River", "North Pole", "South Pole", "Lonely Island", "Muddy Stream"};
        COUNTRIES = new String[]{"UK", "USA", "Germany", "France", "Austria", "Spain", "Italy", "Sweden", "Norway", "Finnland", "Iceland", "Ireland", "Belgium", "Chile", "Japan", "South Korea", "New Zealand", "Australia"};
    }
}

