/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import uk.org.ogsadai.client.dbcreate2.CreateTestDatabaseException;
import uk.org.ogsadai.client.dbcreate2.TravelDataCreator;

public class CreateTestXindiceDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    protected final TravelDataCreator mData = new TravelDataCreator();
    protected String mDBMS;
    protected String mDriver;
    protected String mHost;
    protected String mPort;
    protected String mDatabase;
    protected String mUsername;
    protected String mPassword;
    protected String mCollectionPrefix;
    protected String mTravellerCollection;
    protected String mDestinationCollection;
    protected String mBookingCollection;
    protected int mEntries = 40000;
    protected int mNumberOfTravellers = 10000;
    protected int mNumberOfDestinations = 10000;
    protected int mNumberOfBookings = 20000;

    public CreateTestXindiceDB(String[] args) {
        this.setDefaultSettings();
        if (this.setupArguments(args)) {
            try {
                this.printVariables(this.mDBMS);
                this.populateDatabase();
                System.out.println("Test database created successfully!");
            }
            catch (CreateTestDatabaseException e) {
                System.out.println(e.getLocalizedMessage());
            }
        } else {
            this.printUsage();
            this.printVariables("Default");
        }
    }

    public static void main(String[] args) {
        CreateTestXindiceDB creator = new CreateTestXindiceDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "Xindice";
        this.mDriver = "org.apache.xindice.client.xmldb.DatabaseImpl";
        this.mHost = "localhost";
        this.mPort = "4080";
        this.mDatabase = "db";
        this.mCollectionPrefix = "example_";
        this.mTravellerCollection = "traveller";
        this.mDestinationCollection = "destination";
        this.mBookingCollection = "booking";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        Collection collection = null;
        try {
            Class<?> c = Class.forName(this.mDriver);
            Database db = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)db);
            String xindiceURL = "xmldb:xindice://" + this.mHost + ":" + this.mPort + "/" + this.mDatabase + "/";
            System.out.println("Opening base collection: " + xindiceURL);
            collection = DatabaseManager.getCollection((String)xindiceURL);
            CollectionManagementService service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            this.removeCollectionIfExists(service, collection, this.mBookingCollection);
            this.removeCollectionIfExists(service, collection, this.mDestinationCollection);
            this.removeCollectionIfExists(service, collection, this.mTravellerCollection);
            this.createTravellerCollection(service);
            this.createDestinationCollection(service);
            this.createBookingCollection(service);
            this.closeCollection(collection);
            return;
        }
        catch (XMLDBException e) {
            try {
                throw new CreateTestDatabaseException(e);
                catch (ClassNotFoundException e2) {
                    throw new CreateTestDatabaseException("Cannot find driver class " + this.mDriver, e2);
                }
                catch (InstantiationException e3) {
                    throw new CreateTestDatabaseException("Cannot instantiate driver class " + this.mDriver, e3);
                }
                catch (IllegalAccessException e4) {
                    throw new CreateTestDatabaseException("Cannot instantiate driver class " + this.mDriver, e4);
                }
            }
            catch (Throwable throwable) {
                this.closeCollection(collection);
                throw throwable;
            }
        }
    }

    private void removeCollectionIfExists(CollectionManagementService service, Collection parent, String collectionName) throws XMLDBException {
        Collection child = parent.getChildCollection(collectionName);
        if (child != null) {
            System.out.println("Deleting collection " + collectionName);
            service.removeCollection(collectionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTravellerCollection(CollectionManagementService service) throws XMLDBException {
        Collection child = null;
        try {
            String collectionName = this.mCollectionPrefix + this.mTravellerCollection;
            System.out.println("Creating new collection named '" + collectionName + "'.");
            child = service.createCollection(collectionName);
            System.out.println("Adding " + this.mNumberOfTravellers + " documents to '" + collectionName + "'...");
            for (int i = 1; i <= this.mNumberOfTravellers; ++i) {
                String resourceID = String.valueOf(i);
                String documentString = this.makeTravellerEntry(i);
                XMLResource document = (XMLResource)child.createResource(resourceID, "XMLResource");
                document.setContent((Object)documentString);
                child.storeResource((Resource)document);
            }
            this.closeCollection(child);
        }
        catch (Throwable throwable) {
            this.closeCollection(child);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDestinationCollection(CollectionManagementService service) throws XMLDBException {
        Collection child = null;
        try {
            String collectionName = this.mCollectionPrefix + this.mDestinationCollection;
            System.out.println("Creating new collection named '" + collectionName + "'.");
            child = service.createCollection(collectionName);
            System.out.println("Adding " + this.mNumberOfDestinations + " documents to '" + collectionName + "'...");
            for (int i = 1; i <= this.mNumberOfDestinations; ++i) {
                String resourceID = String.valueOf(i);
                String documentString = this.makeDestinationEntry(i);
                XMLResource document = (XMLResource)child.createResource(resourceID, "XMLResource");
                document.setContent((Object)documentString);
                child.storeResource((Resource)document);
            }
            this.closeCollection(child);
        }
        catch (Throwable throwable) {
            this.closeCollection(child);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBookingCollection(CollectionManagementService service) throws XMLDBException {
        Collection child = null;
        try {
            String collectionName = this.mCollectionPrefix + this.mBookingCollection;
            System.out.println("Creating new collection named '" + collectionName + "'.");
            child = service.createCollection(collectionName);
            System.out.println("Adding " + this.mNumberOfBookings + " documents to '" + collectionName + "'...");
            for (int i = 1; i <= this.mNumberOfBookings; ++i) {
                String resourceID = String.valueOf(i);
                String documentString = this.makeBookingEntry(i);
                XMLResource document = (XMLResource)child.createResource(resourceID, "XMLResource");
                document.setContent((Object)documentString);
                child.storeResource((Resource)document);
            }
            this.closeCollection(child);
        }
        catch (Throwable throwable) {
            this.closeCollection(child);
            throw throwable;
        }
    }

    private void closeCollection(Collection child) {
        if (child != null) {
            try {
                child.close();
                System.out.println("Closed collection " + child.getName());
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        }
    }

    private String makeTravellerEntry(int i) {
        StringBuffer doc = new StringBuffer();
        doc.append("<entry id='" + i + "'>\n");
        doc.append("  <name>");
        doc.append(this.mData.generateName(i));
        doc.append("</name>\n");
        doc.append("  <address>");
        doc.append(this.mData.generateAddress(i));
        doc.append("</address>\n");
        doc.append("  <phone>");
        doc.append(this.mData.generatePhone(i));
        doc.append("</phone>\n");
        doc.append("  <dob>");
        doc.append(this.mData.generateDOB(i));
        doc.append("  </dob>\n");
        doc.append("</entry>");
        return doc.toString();
    }

    private String makeDestinationEntry(int i) {
        StringBuffer doc = new StringBuffer();
        doc.append("<entry id='" + i + "'>\n");
        doc.append("  <name>");
        doc.append(this.mData.generateDestinationName(i));
        doc.append("</name>\n");
        doc.append("  <address>");
        doc.append(this.mData.generateAddress(i));
        doc.append("</address>\n");
        doc.append("  <country>");
        doc.append(this.mData.generateCountry(i));
        doc.append("</country>\n");
        doc.append("  <description>");
        doc.append(this.mData.generateDescription(i));
        doc.append("  </description>\n");
        doc.append("  <photo>");
        doc.append("  </photo>\n");
        doc.append("</entry>");
        return doc.toString();
    }

    private String makeBookingEntry(long i) {
        StringBuffer doc = new StringBuffer();
        doc.append("<entry id='" + i + "'>\n");
        doc.append("  <traveller>");
        doc.append("</traveller>\n");
        doc.append(this.mData.generateTraveller(i, this.mNumberOfTravellers));
        doc.append("  <destination>");
        doc.append(this.mData.generateDestination(i, this.mNumberOfDestinations));
        doc.append("</destination>\n");
        doc.append("  <booking_time>");
        doc.append(this.mData.generateTimestamp(i));
        doc.append("  </booking_time>\n");
        doc.append("  <departure_date>");
        doc.append(this.mData.generateDepartureDate(i));
        doc.append("</departure_date>\n");
        doc.append("  <departure_time>");
        doc.append(this.mData.generateDepartureTime(i));
        doc.append("  </departure_time>\n");
        doc.append("  <price>");
        doc.append(this.mData.generatePrice(i));
        doc.append("  </price>\n");
        doc.append("</entry>");
        return doc.toString();
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.mHost = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.mPort = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-collectionprefix")) {
                this.mCollectionPrefix = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-documents")) {
                this.mEntries = Integer.parseInt(args[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\n\n\tjava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-host " + this.mDBMS + "HostName] " + "[-port " + this.mDBMS + "PortNumber] " + "[-database " + this.mDBMS + "DatabaseName] \n\t\t" + "[-collectionname NameOfCollectionToCreate] " + "[-documents NumberOfDocumentsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t\t" + this.mDriver + "\n\t" + this.mDBMS + "HostName:       \t\t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t\t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t\t" + this.mDatabase + "\n\tNameOfCollectionToCreate: \t" + this.mCollectionPrefix + "\n\tNumberOfDocumentsToCreate:\t" + this.mEntries);
    }
}

