/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate2.CreateTestDB;

public class CreateTestSQLServerDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestSQLServerDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestSQLServerDB creator = new CreateTestSQLServerDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "SQLServer";
        this.mDriver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        this.mHost = "localhost";
        this.mPort = "1433";
        this.mDatabase = "ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
        this.mRows = 40000;
        this.mNumberOfTravellers = 10000;
        this.mNumberOfDestinations = 10000;
        this.mNumberOfBookings = 20000;
        this.mTablePrefix = "example_";
        this.mDestinationTable = "destination";
        this.mTravellerTable = "traveller";
        this.mBookingTable = "booking";
    }

    protected Connection getConnection() throws SQLException {
        String connectionURL = "jdbc:microsoft:sqlserver://" + this.mHost + ":" + this.mPort + ";DatabaseName=" + this.mDatabase;
        System.out.println("Opening connection to: " + connectionURL);
        Connection connection = DriverManager.getConnection(connectionURL, this.mUsername, this.mPassword);
        return connection;
    }

    protected void dropTableIfExists(Connection connection, String tablename) throws SQLException {
        String sDropTableStatement = "if exists (select table_name from information_schema.tables where table_name = '" + tablename + "') drop table " + tablename;
        System.out.println("Deleting " + tablename + " with statement: " + sDropTableStatement);
        Statement dropTableStatement = connection.createStatement();
        dropTableStatement.execute(sDropTableStatement);
    }

    protected String getCreateTravellerTableStatement() {
        return "CREATE TABLE " + this.mTablePrefix + this.mTravellerTable + " (id INTEGER NOT NULL PRIMARY KEY, name VARCHAR(64)," + " address VARCHAR(128), phone VARCHAR(16), dob DATETIME)";
    }

    protected String getCreateDestinationTableStatement() {
        return "CREATE TABLE " + this.mTablePrefix + this.mDestinationTable + "(id SMALLINT NOT NULL PRIMARY KEY, name VARCHAR(64)," + " address VARCHAR(128), country VARCHAR(64)," + " description TEXT, photo IMAGE)";
    }

    protected String getCreateBookingTableStatement() {
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE TABLE ");
        statement.append(this.mTablePrefix);
        statement.append(this.mBookingTable);
        statement.append(" (id BIGINT NOT NULL PRIMARY KEY, destination SMALLINT,");
        statement.append(" traveller INTEGER, booking_time DATETIME, departure_date DATETIME,");
        statement.append(" departure_time DATETIME, price REAL,");
        statement.append(" FOREIGN KEY (destination) REFERENCES ");
        statement.append(this.mTablePrefix);
        statement.append(this.mDestinationTable);
        statement.append("(id),");
        statement.append(" FOREIGN KEY (traveller) REFERENCES ");
        statement.append(this.mTablePrefix);
        statement.append(this.mTravellerTable);
        statement.append("(id))");
        return statement.toString();
    }
}

