/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate2.CreateTestDB;

public class CreateTestPostgreSQLDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestPostgreSQLDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestPostgreSQLDB creator = new CreateTestPostgreSQLDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "PostgreSQL";
        this.mDriver = "org.postgresql.Driver";
        this.mHost = "localhost";
        this.mDatabase = "ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
        this.mPort = "5432";
        this.mNumberOfTravellers = 10000;
        this.mNumberOfDestinations = 10000;
        this.mNumberOfBookings = 20000;
        this.mTablePrefix = "example_";
        this.mDestinationTable = "destination";
        this.mTravellerTable = "traveller";
        this.mBookingTable = "booking";
    }

    protected Connection getConnection() throws SQLException {
        System.out.println("Opening connection to PostgreSQL database");
        Connection connection = DriverManager.getConnection("jdbc:postgresql://" + this.mHost + ":" + this.mPort + "/" + this.mDatabase, this.mUsername, this.mPassword);
        return connection;
    }

    protected void dropTableIfExists(Connection connection, String tablename) throws SQLException {
        Statement checkTableStatement = connection.createStatement();
        ResultSet rs = checkTableStatement.executeQuery("SELECT COUNT(*) FROM pg_class WHERE relname='" + tablename + "'");
        boolean tableExists = false;
        if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
            tableExists = true;
        }
        if (tableExists) {
            System.out.println("Deleting " + tablename + " table in database");
            Statement dropTableStatement = connection.createStatement();
            dropTableStatement.execute("DROP TABLE " + tablename);
        }
    }

    protected String getCreateDestinationTableStatement() {
        return "CREATE TABLE " + this.mTablePrefix + this.mDestinationTable + "(id SMALLINT NOT NULL PRIMARY KEY, name VARCHAR(64)," + " address VARCHAR(128), country VARCHAR(64)," + " description TEXT, photo BYTEA)";
    }
}

