/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate2.CreateTestDB;

public class CreateTestOracleDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestOracleDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestOracleDB creator = new CreateTestOracleDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "Oracle";
        this.mDriver = "oracle.jdbc.driver.OracleDriver";
        this.mHost = "localhost";
        this.mPort = "1521";
        this.mDatabase = "ogsadai";
        this.mUsername = "scott";
        this.mPassword = "tiger";
        this.mNumberOfTravellers = 10000;
        this.mNumberOfDestinations = 10000;
        this.mNumberOfBookings = 20000;
        this.mTablePrefix = "example_";
        this.mDestinationTable = "destination";
        this.mTravellerTable = "traveller";
        this.mBookingTable = "booking";
    }

    protected Connection getConnection() throws SQLException {
        System.out.println("Opening connection to Oracle database");
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@" + this.mHost + ":" + this.mPort + ":" + this.mDatabase, this.mUsername, this.mPassword);
        return connection;
    }

    protected void dropTableIfExists(Connection connection, String tablename) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery("select count(*) from all_tables where table_name = '" + tablename.toUpperCase() + "'");
        boolean tableExist = false;
        if (rs.next() && Integer.parseInt(rs.getString(1)) == 1) {
            tableExist = true;
        }
        if (tableExist) {
            System.out.println("Deleting " + tablename + " table in database");
            Statement dropTableStatement = connection.createStatement();
            dropTableStatement.execute("DROP TABLE " + tablename);
        }
    }

    protected String getCreateDestinationTableStatement() {
        return "CREATE TABLE " + this.mTablePrefix + this.mDestinationTable + "(id SMALLINT NOT NULL PRIMARY KEY, name VARCHAR(64)," + " address VARCHAR(128), country VARCHAR(64)," + " description CLOB, photo BLOB)";
    }

    protected String getCreateBookingTableStatement() {
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE TABLE ");
        statement.append(this.mTablePrefix);
        statement.append(this.mBookingTable);
        statement.append(" (id INTEGER NOT NULL PRIMARY KEY, destination SMALLINT,");
        statement.append(" traveller INTEGER, booking_time TIMESTAMP, departure_date DATE,");
        statement.append(" departure_time DATE, price REAL,");
        statement.append(" FOREIGN KEY (destination) REFERENCES ");
        statement.append(this.mTablePrefix);
        statement.append(this.mDestinationTable);
        statement.append("(id),");
        statement.append(" FOREIGN KEY (traveller) REFERENCES ");
        statement.append(this.mTablePrefix);
        statement.append(this.mTravellerTable);
        statement.append("(id))");
        return statement.toString();
    }
}

