/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.client.dbcreate2.CreateTestDB;

public class CreateTestDerbyDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";

    public CreateTestDerbyDB(String[] args) {
        super(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "derby";
        this.mDriver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.mDatabase = "C:/Downloads/Derby/ogsadai";
        this.mUsername = "ogsadai";
        this.mPassword = "ogsadai";
        this.mNumberOfTravellers = 10000;
        this.mNumberOfDestinations = 10000;
        this.mNumberOfBookings = 20000;
        this.mTablePrefix = "example_";
        this.mDestinationTable = "destination";
        this.mTravellerTable = "traveller";
        this.mBookingTable = "booking";
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-username")) {
                this.mUsername = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-password")) {
                this.mPassword = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-tableprefix")) {
                this.mTablePrefix = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mRows = Integer.parseInt(args[i + 1]);
                this.mNumberOfTravellers = this.mRows / 4;
                this.mNumberOfDestinations = this.mRows / 4;
                this.mNumberOfBookings = this.mRows / 2;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\njava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-database " + this.mDBMS + "DatabasePath] \n\t\t" + "[-username " + this.mDBMS + "UserName] " + "[-password " + this.mDBMS + "Password] \n\t\t" + "[-tableprefix PrefixOfTablesToCreate] " + "[-rows NumberOfRowsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t" + this.mDriver + "\n\t" + this.mDBMS + "DatabasePath:   \t" + this.mDatabase + "\n\t" + this.mDBMS + "UserName:       \t" + this.mUsername + "\n\t" + this.mDBMS + "Password:       \t" + this.mPassword + "\n\tTablePrefixToCreate: \t" + this.mTablePrefix + "\n\tNumberOfRowsToCreate:\t" + this.mRows);
    }

    public static void main(String[] args) {
        CreateTestDerbyDB creator = new CreateTestDerbyDB(args);
    }

    protected Connection getConnection() throws SQLException {
        System.out.println("Opening connection to Derby database");
        Connection connection = DriverManager.getConnection("jdbc:derby:" + this.mDatabase + ";create = true", this.mUsername, this.mPassword);
        return connection;
    }

    protected void dropTableIfExists(Connection connection, String tablename) throws SQLException {
        boolean tableExist = false;
        Statement createTableStatement = connection.createStatement();
        ResultSet rs = createTableStatement.executeQuery("select count(*) from SYS.SYSTABLES where tablename = '" + tablename.toUpperCase() + "'");
        if (rs.next()) {
            System.out.println("tab exists " + Integer.parseInt(rs.getString(1)));
            if (Integer.parseInt(rs.getString(1)) == 1) {
                tableExist = true;
            }
        }
        if (tableExist) {
            System.out.println("Deleting " + tablename + " table in database");
            Statement dropTableStatement = connection.createStatement();
            dropTableStatement.execute("DROP TABLE " + tablename);
        }
    }
}

