/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate2;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import uk.org.ogsadai.client.dbcreate2.CreateTestDatabaseException;
import uk.org.ogsadai.client.dbcreate2.TravelDataCreator;

public abstract class CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    protected final TravelDataCreator mData = new TravelDataCreator();
    protected String mDBMS;
    protected String mDriver;
    protected String mHost;
    protected String mPort;
    protected String mDatabase;
    protected String mUsername;
    protected String mPassword;
    protected String mTablePrefix;
    protected String mTravellerTable;
    protected String mDestinationTable;
    protected String mBookingTable;
    protected int mRows = 40000;
    protected int mNumberOfTravellers = 10000;
    protected int mNumberOfDestinations = 10000;
    protected int mNumberOfBookings = 20000;
    protected int mSizeOfBlob = 1000;

    public CreateTestDB(String[] args) {
        this.setDefaultSettings();
        if (this.setupArguments(args)) {
            try {
                this.printVariables(this.mDBMS);
                this.populateDatabase();
                System.out.println("Test database created successfully!");
            }
            catch (CreateTestDatabaseException e) {
                System.out.println(e.getLocalizedMessage());
            }
        } else {
            this.printUsage();
            this.printVariables("Default");
        }
    }

    protected abstract void setDefaultSettings();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        this.loadDriver();
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.dropTableIfExists(connection, this.mTablePrefix + this.mBookingTable);
                this.dropTableIfExists(connection, this.mTablePrefix + this.mTravellerTable);
                this.dropTableIfExists(connection, this.mTablePrefix + this.mDestinationTable);
                this.createTravellerTable(connection);
                this.createDestinationTable(connection);
                this.createBookingTable(connection);
            }
            catch (SQLException e) {
                throw new CreateTestDatabaseException(e);
            }
            Object var4_2 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        connection.close();
        return;
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.mHost = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.mPort = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-username")) {
                this.mUsername = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-password")) {
                this.mPassword = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-tableprefix")) {
                this.mTablePrefix = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-rows")) {
                this.mRows = Integer.parseInt(args[i + 1]);
                this.mNumberOfTravellers = this.mRows / 4;
                this.mNumberOfDestinations = this.mRows / 4;
                this.mNumberOfBookings = this.mRows / 2;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\njava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-host " + this.mDBMS + "HostName] " + "[-port " + this.mDBMS + "PortNumber] " + "[-database " + this.mDBMS + "DatabaseName] \n\t\t" + "[-username " + this.mDBMS + "UserName] " + "[-password " + this.mDBMS + "Password] \n\t\t" + "[-tableprefix PrefixOfTablesToCreate] " + "[-rows NumberOfRowsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t" + this.mDriver + "\n\t" + this.mDBMS + "HostName:       \t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t" + this.mDatabase + "\n\t" + this.mDBMS + "UserName:       \t" + this.mUsername + "\n\t" + this.mDBMS + "Password:       \t" + this.mPassword + "\n\tPrefixOfTablesToCreate: \t" + this.mTablePrefix + "\n\tNumberOfRowsToCreate:\t" + this.mRows);
    }

    protected void loadDriver() throws CreateTestDatabaseException {
        try {
            Class.forName(this.mDriver);
        }
        catch (ClassNotFoundException e) {
            throw new CreateTestDatabaseException("Cannot find driver class " + this.mDriver, e);
        }
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void dropTableIfExists(Connection var1, String var2) throws SQLException;

    protected String getCreateTravellerTableStatement() {
        return "CREATE TABLE " + this.mTablePrefix + this.mTravellerTable + " (id INTEGER NOT NULL PRIMARY KEY, name VARCHAR(64)," + " address VARCHAR(128), phone VARCHAR(16), dob DATE)";
    }

    protected String getCreateBookingTableStatement() {
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE TABLE ");
        statement.append(this.mTablePrefix);
        statement.append(this.mBookingTable);
        statement.append(" (id BIGINT NOT NULL PRIMARY KEY, destination SMALLINT,");
        statement.append(" traveller INTEGER, booking_time TIMESTAMP, departure_date DATE,");
        statement.append(" departure_time TIME, price REAL,");
        statement.append(" FOREIGN KEY (destination) REFERENCES ");
        statement.append(this.mTablePrefix);
        statement.append(this.mDestinationTable);
        statement.append("(id),");
        statement.append(" FOREIGN KEY (traveller) REFERENCES ");
        statement.append(this.mTablePrefix);
        statement.append(this.mTravellerTable);
        statement.append("(id))");
        return statement.toString();
    }

    protected String getCreateDestinationTableStatement() {
        return "CREATE TABLE " + this.mTablePrefix + this.mDestinationTable + "(id SMALLINT NOT NULL PRIMARY KEY, name VARCHAR(64)," + " address VARCHAR(128), country VARCHAR(64)," + " description TEXT, photo BLOB)";
    }

    protected void createTravellerTable(Connection connection) throws SQLException {
        String tablename = this.mTablePrefix + this.mTravellerTable;
        Statement createTableStatement = connection.createStatement();
        System.out.println("Creating " + tablename + " table in database");
        createTableStatement.execute(this.getCreateTravellerTableStatement());
        System.out.println("Preparing insert statement");
        PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + tablename + " (id, name, address, phone, dob) VALUES (?, ?, ?, ?, ?)");
        System.out.println("Adding " + this.mNumberOfTravellers + " entries to '" + tablename + "'...");
        for (int i = 1; i <= this.mNumberOfTravellers; ++i) {
            insertStatement.setInt(1, i);
            insertStatement.setString(2, this.mData.generateName(i));
            insertStatement.setString(3, this.mData.generateAddress(i));
            insertStatement.setString(4, this.mData.generatePhone(i));
            insertStatement.setDate(5, Date.valueOf(this.mData.generateDOB(i)));
            insertStatement.execute();
        }
    }

    protected void createDestinationTable(Connection connection) throws SQLException {
        String tablename = this.mTablePrefix + this.mDestinationTable;
        Statement createTableStatement = connection.createStatement();
        System.out.println("Creating " + tablename + " table in database");
        createTableStatement.execute(this.getCreateDestinationTableStatement());
        System.out.println("Preparing insert statement");
        PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + tablename + " (id, name, address, country, description, photo)" + " VALUES (?, ?, ?, ?, ?, ?)");
        int numberOfDestinations = 10000;
        System.out.println("Adding " + numberOfDestinations + " entries to '" + tablename + "'...");
        for (int i = 1; i <= numberOfDestinations; ++i) {
            insertStatement.setInt(1, i);
            insertStatement.setString(2, this.mData.generateDestinationName(i));
            insertStatement.setString(3, this.mData.generateAddress(i));
            insertStatement.setString(4, this.mData.generateCountry(i));
            insertStatement.setString(5, this.mData.generateDescription(i));
            insertStatement.setBytes(6, this.mData.generateBytes(i, this.mSizeOfBlob));
            insertStatement.execute();
        }
    }

    protected void createBookingTable(Connection connection) throws SQLException {
        String tablename = this.mTablePrefix + this.mBookingTable;
        System.out.println("Creating " + tablename + " table in database");
        Statement createTableStatement = connection.createStatement();
        createTableStatement.execute(this.getCreateBookingTableStatement());
        System.out.println("Preparing insert statement");
        PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO " + tablename + " (id, destination, traveller, booking_time, departure_date," + " departure_time, price) VALUES (?, ?, ?, ?, ?, ?, ?)");
        System.out.println("Adding " + this.mNumberOfBookings + " entries to '" + tablename + "'...");
        for (long i = 1L; i <= (long)this.mNumberOfBookings; ++i) {
            insertStatement.setLong(1, i);
            insertStatement.setInt(2, this.mData.generateTraveller(i, this.mNumberOfTravellers));
            insertStatement.setInt(3, this.mData.generateDestination(i, this.mNumberOfDestinations));
            insertStatement.setTimestamp(4, Timestamp.valueOf(this.mData.generateTimestamp(i)));
            insertStatement.setDate(5, Date.valueOf(this.mData.generateDepartureDate(i)));
            insertStatement.setTime(6, Time.valueOf(this.mData.generateDepartureTime(i)));
            insertStatement.setDouble(7, this.mData.generatePrice(i));
            insertStatement.execute();
        }
    }
}

