/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.dbcreate;

import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import uk.org.ogsadai.client.dbcreate.CreateTestDB;
import uk.org.ogsadai.client.dbcreate.CreateTestDatabaseException;

public class CreateTestXindiceDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private String mNewCollectionName;

    public CreateTestXindiceDB(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        CreateTestXindiceDB creator = new CreateTestXindiceDB(args);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "Xindice";
        this.mDriver = "org.apache.xindice.client.xmldb.DatabaseImpl";
        this.mHost = "localhost";
        this.mPort = "4080";
        this.mDatabase = "db";
        this.mNewCollectionName = "littleblackbook";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        Collection collection = null;
        Collection child = null;
        try {
            Class<?> c = Class.forName(this.mDriver);
            Database db = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)db);
            String xindiceURL = "xmldb:xindice://" + this.mHost + ":" + this.mPort + "/" + this.mDatabase + "/";
            System.out.println("Opening base collection: " + xindiceURL);
            collection = DatabaseManager.getCollection((String)xindiceURL);
            CollectionManagementService service = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            child = collection.getChildCollection(this.mNewCollectionName);
            if (child != null) {
                throw new CreateTestDatabaseException("Collection " + this.mNewCollectionName + " already exists");
            }
            System.out.println("Creating new collection named '" + this.mNewCollectionName + "'.");
            child = service.createCollection(this.mNewCollectionName);
            System.out.println("Adding " + this.mNumberOfEntries + " documents to '" + this.mNewCollectionName + "'...");
            int i = 1;
            while (true) {
                if (i > this.mNumberOfEntries) {
                    this.closeCollection(child);
                    this.closeCollection(collection);
                    return;
                }
                String resourceID = String.valueOf(i);
                String documentString = this.makeDocument(i);
                XMLResource document = (XMLResource)child.createResource(resourceID, "XMLResource");
                document.setContent((Object)documentString);
                child.storeResource((Resource)document);
                ++i;
            }
        }
        catch (XMLDBException e) {
            try {
                throw new CreateTestDatabaseException(e);
                catch (ClassNotFoundException e2) {
                    throw new CreateTestDatabaseException("Cannot find driver class " + this.mDriver, e2);
                }
                catch (InstantiationException e3) {
                    throw new CreateTestDatabaseException("Cannot instantiate driver class " + this.mDriver, e3);
                }
                catch (IllegalAccessException e4) {
                    throw new CreateTestDatabaseException("Cannot instantiate driver class " + this.mDriver, e4);
                }
            }
            catch (Throwable throwable) {
                this.closeCollection(child);
                this.closeCollection(collection);
                throw throwable;
            }
        }
    }

    private void closeCollection(Collection child) {
        if (child != null) {
            try {
                child.close();
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        }
    }

    private String makeDocument(int i) {
        StringBuffer doc = new StringBuffer();
        doc.append("<entry id='" + i + "'>\n");
        doc.append("  <name>");
        doc.append(this.mData.generateName(i));
        doc.append("</name>\n");
        doc.append("  <address>");
        doc.append(this.mData.generateAddress());
        doc.append("</address>\n");
        doc.append("  <phone>");
        doc.append(this.mData.generatePhone());
        doc.append("</phone>\n");
        doc.append("</entry>");
        return doc.toString();
    }

    protected boolean setupArguments(String[] args) {
        if (args.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.mHost = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.mPort = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-database")) {
                this.mDatabase = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-collectionname")) {
                this.mNewCollectionName = args[i + 1];
                continue;
            }
            if (args[i].toLowerCase().equals("-documents")) {
                this.mNumberOfEntries = Integer.parseInt(args[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\n\n\tjava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-host " + this.mDBMS + "HostName] " + "[-port " + this.mDBMS + "PortNumber] " + "[-database " + this.mDBMS + "DatabaseName] \n\t\t" + "[-collectionname NameOfCollectionToCreate] " + "[-documents NumberOfDocumentsToCreate]");
    }

    protected void printVariables(String prefix) {
        System.out.println(prefix + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t\t" + this.mDriver + "\n\t" + this.mDBMS + "HostName:       \t\t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t\t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t\t" + this.mDatabase + "\n\tNameOfCollectionToCreate: \t" + this.mNewCollectionName + "\n\tNumberOfDocumentsToCreate:\t" + this.mNumberOfEntries);
    }
}

